package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 发行+购买结果查询
 * @class: GalaxyNftPublishResultQueryRespDto
 * @Package com.liquidnet.service.galaxy.dto.param
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/28 11:22
 */
@ApiModel(value = "GalaxyNftPublishAndBuyRouterBatchQueryRespDto", description = "NFT发行结果查询")
@Data
public class GalaxyNftPublishAndBuyRouterBatchQueryRespDto implements Serializable,Cloneable {

    @ApiModelProperty(position = 1, required = true, value = "用户ID[30]")
    private String userId;
    
    /**
     * 路由类型(至信链zxinchain、以太坊eth)
     */
    @ApiModelProperty(position = 1, required = true, value = "路由类型(至信链zxinchain、以太坊eth)")
    @NotBlank(message = "路由类型不能为空！")
    private String routerType;

    @ApiModelProperty(position = 1, required = true, value = "用户购买信息List")
    private List<GalaxyNftPublishAndBuyResultQueryRespDto> buyInfoList;

    @Override
    public String toString() {
        return JsonUtils.toJson(this);
    }

    private static final GalaxyNftPublishAndBuyRouterBatchQueryRespDto obj = new GalaxyNftPublishAndBuyRouterBatchQueryRespDto();

    public static GalaxyNftPublishAndBuyRouterBatchQueryRespDto getNew() {
        try {
            return (GalaxyNftPublishAndBuyRouterBatchQueryRespDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyNftPublishAndBuyRouterBatchQueryRespDto();
        }
    }
}
