package com.liquidnet.service.goblin.controller;

import com.liquidnet.service.base.PagedResult;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.GoblinNftOrderDetailsVo;
import com.liquidnet.service.goblin.service.IGoblinNftOrderAppService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;

@Slf4j
@Api(tags = "NFT订单相关-App")
@RestController
@Validated
@RequestMapping("/nftOrder")
public class GoblinNftOrderAppController {

    @Autowired
    IGoblinNftOrderAppService goblinNftOrderAppService;

    @PostMapping("list")
    @ApiOperation("用户订单列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "Integer", name = "page", value = "页数", example = "1"),
    })
    public ResponseDto<PagedResult<GoblinNftOrderDetailsVo>> orderList(
            @RequestParam(value = "page", defaultValue = "1") int page
    ) {
        return goblinNftOrderAppService.orderList(page);
    }

    @PostMapping("details")
    @ApiOperation("订单详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "orderId", value = "订单ID", example = "1"),
    })
    public ResponseDto<GoblinNftOrderDetailsVo> orderDetails(@RequestParam("orderId") @NotBlank(message = "订单ID不能为空") String orderId) {
        return goblinNftOrderAppService.orderDetails(orderId);
    }

}
