package com.liquidnet.client.admin.zhengzai.kylin.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.kylin.entity.KylinRecommendActive;
import com.liquidnet.service.kylin.entity.KylinRecommendActiveRelation;
import com.liquidnet.service.kylin.mapper.KylinRecommendActiveRelationMapper;
import com.liquidnet.service.kylin.service.admin.IKylinRecommendActiveRelationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

/**
 * <p>
 * 推荐活动关联表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2022-07-27
 */
@Service
public class KylinRecommendActiveRelationServiceImpl extends ServiceImpl<KylinRecommendActiveRelationMapper, KylinRecommendActiveRelation> implements IKylinRecommendActiveRelationService {
    @Autowired
    private KylinRecommendActiveServiceImpl kylinRecommendActiveService;
    @Autowired
    private KylinRecommendActiveRelationMapper kylinRecommendActiveRelationMapper;
    @Override
    public boolean addKylinRecommendActiveRelation(KylinRecommendActiveRelation kylinRecommendActiveRelation) {
        kylinRecommendActiveRelation.setDelTag(0);
        kylinRecommendActiveRelation.setUpdatedAt(LocalDateTime.now());
        kylinRecommendActiveRelation.setCreatedAt(LocalDateTime.now());
        kylinRecommendActiveRelation.setRecommendRelationId(IDGenerator.nextSnowId());
        kylinRecommendActiveRelationMapper.insert(kylinRecommendActiveRelation);
        //更新 redis
        KylinRecommendActive byRecommendId = kylinRecommendActiveService.getByRecommendId(kylinRecommendActiveRelation.getRecommendActiveId());
        kylinRecommendActiveService.updateRedis(byRecommendId);
        return true;
    }

    @Override
    public boolean deleteKylinRecommendActiveRelation(KylinRecommendActiveRelation kylinRecommendActiveRelation) {
        kylinRecommendActiveRelation.setDelTag(1);
        kylinRecommendActiveRelationMapper.updateById(kylinRecommendActiveRelation);
        //更新 redis
        KylinRecommendActive byRecommendId = kylinRecommendActiveService.getByRecommendId(kylinRecommendActiveRelation.getRecommendActiveId());
        kylinRecommendActiveService.updateRedis(byRecommendId);
        return true;
    }


}
