package com.liquidnet.service.order.service.impl;

import com.alibaba.fastjson.JSON;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.kylin.constant.KylinTableStatusConst;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderRefundEntitiesVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketEntitiesVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketVo;
import com.liquidnet.service.kylin.dto.vo.returns.KylinOrderRefundsVo;
import com.liquidnet.service.kylin.entity.KylinOrderRefundEntities;
import com.liquidnet.service.kylin.entity.KylinOrderRefunds;
import com.liquidnet.service.kylin.entity.KylinOrderTicketEntities;
import com.liquidnet.service.kylin.entity.KylinOrderTicketStatus;
import com.liquidnet.service.order.utils.DataUtils;
import com.liquidnet.service.order.utils.ObjectUtil;
import com.liquidnet.service.order.utils.OrderUtils;
import com.liquidnet.service.order.utils.QueueUtils;
import com.mongodb.BasicDBObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.List;

/**
 * <p>
 * 订单退款表 服务实现类 处理数据 退款后状态的变化
 * </p>
 *
 * @author jiaangxiulong
 * @since 2021-05-26
 */
@Slf4j
@Service
public class KylinRefundsStatusServiceImpl {

    @Autowired
    MongoTemplate mongoTemplate;

    @Autowired
    private DataUtils dataUtils;

    @Autowired
    private OrderUtils orderUtils;
    @Autowired
    private QueueUtils queueUtils;

    public Boolean orderTicketRefunding(
            KylinOrderTicketVo orderInfo, String orderTicketsId,
            BigDecimal RefundPriceExpress,
            List<String> ticketEntityIds, List<BigDecimal> entitiesPrice, String paymentId, String paymentType
    ) {
        log.info("订单超时支付refundApply-orderTicketRefunding：[orderInfo={}, [orderTicketsId={}, RefundPriceExpress={}, ticketEntityIds={}, [entitiesPrice={}, paymentId={}, paymentType={}]",
                orderInfo, orderTicketsId, RefundPriceExpress, ticketEntityIds, entitiesPrice, paymentId, paymentType);
        if (CollectionUtil.isEmpty(ticketEntityIds)) {
            return false;
        }
        // 基础数据
        String authId = "";
        String authName = "system_overtime_order_refund";
        String reason = "订单支付超时自动退款";
        // 本次退款票总金额
        BigDecimal entitiesPriceSum = entitiesPrice.stream().reduce(BigDecimal.ZERO, BigDecimal::add);

        // 更新数据
        // 订单状态表 和 缓存
        LocalDateTime nowTime = LocalDateTime.now();
        String nowTimeStr = DateUtil.Formatter.yyyyMMddHHmmss.format(nowTime);
        KylinOrderTicketStatus orderStatusTable = KylinOrderTicketStatus.getNew();
        orderStatusTable.setStatus(KylinTableStatusConst.ORDER_STATUS3);
        orderStatusTable.setUpdatedAt(nowTime);

        KylinOrderTicketVo kylinOrderTicketVo = KylinOrderTicketVo.getNew();
        kylinOrderTicketVo.setStatus(KylinTableStatusConst.ORDER_STATUS3);
        kylinOrderTicketVo.setUpdatedAt(nowTimeStr);
        BasicDBObject orderObject = ObjectUtil.cloneBasicDBObject().append("$set", JSON.parse(JsonUtils.toJson(kylinOrderTicketVo)));
        mongoTemplate.getCollection(KylinOrderTicketVo.class.getSimpleName()).updateOne(
                Query.query(Criteria.where("orderTicketsId").is(orderTicketsId)).getQueryObject(),
                orderObject
        );
        dataUtils.delOrderTicketRedis(orderTicketsId);

        // 订单入场人表 和 缓存
        KylinOrderTicketEntities entitiesTable = KylinOrderTicketEntities.getNew();
        entitiesTable.setIsPayment(KylinTableStatusConst.ENTITIES_IS_PAYMENT2);
        entitiesTable.setUpdatedAt(nowTime);

        LinkedList<Object[]> sqlsDataB = ObjectUtil.cloneLinkedListObj();
        LocalDateTime now1 = LocalDateTime.now();
        for (String v : ticketEntityIds) {
            sqlsDataB.add(new Object[]{
                    entitiesTable.getIsPayment(), entitiesTable.getUpdatedAt(), v, now1, now1
            });

            mongoTemplate.getCollection(KylinOrderTicketEntitiesVo.class.getSimpleName()).updateOne(
                    Query.query(Criteria.where("orderTicketEntitiesId").is(v)).getQueryObject(),
                    new Document("$set", new Document("isPayment", KylinTableStatusConst.ENTITIES_IS_PAYMENT2)
                            .append("updatedAt", nowTimeStr))
            );

            dataUtils.delOrderTicketEntitiesRedis(v);
        }

        // 生成订单列表缓存
        orderUtils.resetOrderListVo(orderInfo.getUserId(), 2, orderTicketsId, null);

        // 退款明细
        KylinOrderRefunds kylinOrderRefunds = KylinOrderRefunds.getNew();
        String orderRefundsId = IDGenerator.nextSnowId();
        kylinOrderRefunds.setOrderRefundsId(orderRefundsId);
        kylinOrderRefunds.setOrderTicketsId(orderTicketsId);
        String orderRefundCode = orderInfo.getOrderCode();
        String codeNum = StringUtils.leftPad(String.valueOf(5), 3, "0");
        kylinOrderRefunds.setOrderRefundCode(orderRefundCode.concat(codeNum));
        kylinOrderRefunds.setPrice(entitiesPriceSum);
        kylinOrderRefunds.setPriceExpress(RefundPriceExpress);
        kylinOrderRefunds.setStatus(KylinTableStatusConst.ORDER_REFUND_STATUS_APPLY);
        kylinOrderRefunds.setType(KylinTableStatusConst.ORDER_REFUND_TYPE_AUTO);
        kylinOrderRefunds.setApplicantId(authId);
        kylinOrderRefunds.setApplicantName(authName);
        kylinOrderRefunds.setApplicantAt(nowTime);
        kylinOrderRefunds.setReason(reason);
        kylinOrderRefunds.setCreatedAt(nowTime);

        KylinOrderRefundsVo orderRefundsVo = KylinOrderRefundsVo.getNew();
        BeanUtils.copyProperties(kylinOrderRefunds, orderRefundsVo);
        mongoTemplate.insert(orderRefundsVo, KylinOrderRefundsVo.class.getSimpleName());

        // 退款入场人表
        KylinOrderRefundEntities kylinOrderRefundEntities = KylinOrderRefundEntities.getNew();
        kylinOrderRefundEntities.setOrderRefundsId(orderRefundsId);
        kylinOrderRefundEntities.setCreatedAt(LocalDateTime.now());
        LinkedList<Object[]> sqlsDataD = ObjectUtil.cloneLinkedListObj();
        for (int i = 0; i <= ticketEntityIds.size() - 1; i++) {
            String orderRefundsEntitiesId = IDGenerator.nextSnowId();
            kylinOrderRefundEntities.setOrderRefundsEntitiesId(orderRefundsEntitiesId);
            kylinOrderRefundEntities.setRefundPrice(entitiesPrice.get(i));
            kylinOrderRefundEntities.setOrderTicketEntitiesId(ticketEntityIds.get(i));

            sqlsDataD.add(new Object[]{
                    kylinOrderRefundEntities.getOrderRefundsEntitiesId(), kylinOrderRefundEntities.getOrderRefundsId(), kylinOrderRefundEntities.getRefundPrice(),
                    kylinOrderRefundEntities.getOrderTicketEntitiesId(), kylinOrderRefundEntities.getCreatedAt()
            });

            KylinOrderRefundEntitiesVo orderRefundEntitiesVo = KylinOrderRefundEntitiesVo.getNew();
            BeanUtils.copyProperties(kylinOrderRefundEntities, orderRefundEntitiesVo);
            mongoTemplate.insert(orderRefundEntitiesVo, KylinOrderRefundEntitiesVo.class.getSimpleName());
        }

        //mq更改数据库
        LinkedList<String> sqls = ObjectUtil.cloneLinkedListStr();
        LinkedList<Object[]> sqlsDataA = ObjectUtil.cloneLinkedListObj();
        LinkedList<Object[]> sqlsDataC = ObjectUtil.cloneLinkedListObj();
        LinkedList<Object[]> sqlsDataE = ObjectUtil.cloneLinkedListObj();

        sqls.add(SqlMapping.get("kylin_order_ticket_status.overtimeRefund"));
        sqls.add(SqlMapping.get("kylin_order_ticket_entities.overtimeRefund"));
        sqls.add(SqlMapping.get("kylin_order_refund.overtimeRefund"));
        sqls.add(SqlMapping.get("kylin_order_refund_entities.overtimeRefund"));
        sqls.add(SqlMapping.get("kylin_order_tickets.overtimeRefund"));

        sqlsDataE.add(new Object[]{
                paymentId, paymentType, orderStatusTable.getUpdatedAt(),
                orderInfo.getOrderTicketsId(), now1, now1
        });

        sqlsDataA.add(new Object[]{
                orderStatusTable.getStatus(), orderStatusTable.getUpdatedAt(), orderInfo.getOrderTicketsId(),
                now1, now1
        });

        sqlsDataC.add(new Object[]{
                kylinOrderRefunds.getOrderRefundsId(), kylinOrderRefunds.getOrderTicketsId(), kylinOrderRefunds.getOrderRefundCode(),
                kylinOrderRefunds.getPrice(), kylinOrderRefunds.getPriceExpress(), kylinOrderRefunds.getStatus(),
                kylinOrderRefunds.getType(), kylinOrderRefunds.getApplicantId(), kylinOrderRefunds.getApplicantName(),
                kylinOrderRefunds.getApplicantAt(), kylinOrderRefunds.getReason(),
                kylinOrderRefunds.getCreatedAt()
        });

        queueUtils.sendMsgByRedis(MQConst.KylinQueue.SQL_ORDER_OVERTIME_REFUND.getKey(),
                SqlMapping.gets(sqls, sqlsDataA, sqlsDataB, sqlsDataC, sqlsDataD, sqlsDataE));

        return true;
    }
}
