package com.liquidnet.client.admin.web.controller.zhengzai.kylin;


import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.zhengzai.kylin.service.impl.KylinRecommendActiveRelationServiceImpl;
import com.liquidnet.client.admin.zhengzai.kylin.service.impl.KylinRecommendActiveServiceImpl;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.kylin.dto.param.KylinRecommendActiveParam;
import com.liquidnet.service.kylin.dto.param.KylinRecommendActiveRelationParam;
import com.liquidnet.service.kylin.entity.KylinRecommendActive;
import com.liquidnet.service.kylin.entity.KylinRecommendActiveRelation;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 推荐活动表 前端控制器
 * </p>
 */
@Api(tags = "推荐活动controller")
@RestController
@RequestMapping("/kylin-recommend-active")
public class KylinRecommendActiveController extends BaseController {
    @Autowired
    private KylinRecommendActiveServiceImpl kylinRecommendActiveService;
    @Autowired
    private KylinRecommendActiveRelationServiceImpl kylinRecommendActiveRelationService;

    @PostMapping("addKylinRecommendActive")
    @ApiOperation(value = "增加活动")
    @ResponseBody
    public AjaxResult addKylinRecommendActive(@Validated @RequestBody KylinRecommendActiveParam kylinRecommendActiveParam,BindingResult result) {
        if (result!=null&&result.hasErrors()) {
            List<ObjectError> errors = result.getAllErrors();
            if (errors != null) {
                return AjaxResult.error(errors.get(0).getDefaultMessage());
            }
        }
        KylinRecommendActive kylinRecommendActive = new KylinRecommendActive();
        BeanUtils.copyProperties(kylinRecommendActiveParam, kylinRecommendActive);
        if (kylinRecommendActiveService.validateTime(kylinRecommendActive) == 0) {
            List<KylinRecommendActiveRelation> list = new ArrayList<KylinRecommendActiveRelation>();
            if (kylinRecommendActiveParam.getList() != null) {

                for(KylinRecommendActiveRelationParam r:kylinRecommendActiveParam.getList()){
                    KylinRecommendActiveRelation kylinRecommendActiveRelation = new KylinRecommendActiveRelation();
                    if(StringUtil.isBlank(r.getRecommendBindId())){
                        return AjaxResult.error("操作失败", "推荐商品id不能为空");
                    }else if(StringUtil.isBlank(r.getRecommendActiveId())){
                        return AjaxResult.error("操作失败", "推荐活动id不能为空");
                    }else if(null==r.getType()){
                        return AjaxResult.error("操作失败", "推荐类型不能为空");
                    }
                    BeanUtils.copyProperties(r, kylinRecommendActiveRelation);
                    list.add(kylinRecommendActiveRelation);
                }
           /*     kylinRecommendActiveParam.getList().forEach(r -> {

                });*/
            }
            kylinRecommendActiveService.addKylinRecommendActive(kylinRecommendActive, list);
            return AjaxResult.success("操作成功", "");
        } else {
            return AjaxResult.error("该时间段已经重复，请重新选择");
        }
    }

    @PostMapping("addKylinRecommendActiveRelation")
    @ApiOperation(value = "增加活动推荐")
    @ResponseBody
    public AjaxResult addKylinRecommendActiveRelation(@RequestBody KylinRecommendActiveRelationParam kylinRecommendActiveParam) {
        KylinRecommendActiveRelation kylinRecommendActiveRelation = new KylinRecommendActiveRelation();
        BeanUtils.copyProperties(kylinRecommendActiveParam, kylinRecommendActiveRelation);
        kylinRecommendActiveRelationService.addKylinRecommendActiveRelation(kylinRecommendActiveRelation);
        return AjaxResult.success("操作成功", "");
    }
    @PostMapping("addOrUpdateListKylinRecommendActiveRelation")
    @ApiOperation(value = "增加或者修改活动推荐List")
    @ResponseBody
    public AjaxResult addOrUpdateListKylinRecommendActiveRelation(@RequestBody List<KylinRecommendActiveRelationParam> kylinRecommendActiveParam) {
        for(KylinRecommendActiveRelationParam k:kylinRecommendActiveParam){
            if(StringUtil.isBlank(k.getRecommendBindId())){
                return AjaxResult.error("操作失败", "推荐商品id不能为空");
            }else if(StringUtil.isBlank(k.getRecommendActiveId())){
                return AjaxResult.error("操作失败", "推荐活动id不能为空");
            }else if(null==k.getType()){
                return AjaxResult.error("操作失败", "推荐类型不能为空");
            }
        }
        if(kylinRecommendActiveParam.size()>20){
            return AjaxResult.error("操作失败", "推荐活动不允许超过20个！！！");
        }
        List<KylinRecommendActiveRelation> list=new ArrayList<>();
        for(KylinRecommendActiveRelationParam ky:kylinRecommendActiveParam){
            KylinRecommendActiveRelation kylinRecommendActiveRelation = new KylinRecommendActiveRelation();
            BeanUtils.copyProperties(ky, kylinRecommendActiveRelation);
            list.add(kylinRecommendActiveRelation);
        }
        kylinRecommendActiveRelationService.addListKylinRecommendActiveRelation(list);
        return AjaxResult.success("操作成功", "");
    }

    @PostMapping("delKylinRecommendActiveRelation")
    @ApiOperation(value = "删除活动推荐(传入互动推荐里面的mid)")
    @ResponseBody
    public AjaxResult delKylinRecommendActiveRelation(@RequestBody KylinRecommendActiveRelation kylinRecommendActiveRelation) {
        kylinRecommendActiveRelationService.deleteKylinRecommendActiveRelation(kylinRecommendActiveRelation);
        return AjaxResult.success("操作成功", "");
    }


    @PostMapping("updateKylinRecommendActive")
    @ApiOperation(value = "修改活动")
    @ResponseBody
    public AjaxResult updateKylinRecommendActive(@Validated @RequestBody  KylinRecommendActiveParam kylinRecommendActiveParam, BindingResult result) {
        /*BindingResult result = exception.getBindingResult();*/
        if (result!=null&&result.hasErrors()) {
            List<ObjectError> errors = result.getAllErrors();
            if (errors != null) {
                return AjaxResult.error(errors.get(0).getDefaultMessage());
            }
        }
        KylinRecommendActive kylinRecommendActive = new KylinRecommendActive();
        BeanUtils.copyProperties(kylinRecommendActiveParam, kylinRecommendActive);
        if (kylinRecommendActiveService.validateTime(kylinRecommendActive) == 0) {
            kylinRecommendActiveService.updateKylinRecommendActive(kylinRecommendActive);
            return AjaxResult.success("操作成功", "");
        } else {
            return AjaxResult.error("该时间段已经重复，请重新选择");
        }

    }


    @PostMapping("pageActive")
    @ApiOperation(value = "分页活动")
    @ResponseBody
    public TableDataInfo pageActive(@RequestParam(name = "pageSize", required = true) int pageSize, @RequestParam(name = "pageNum", required = true) int pageNum) {
        //return AjaxResult.success(kylinAcitveService.pageKylinAcitve(pageSize,pageNum));
        return getDataTable(kylinRecommendActiveService.pageKylinAcitve(pageSize, pageNum));
    }

    @PostMapping("getActiveById")
    @ApiOperation(value = "通过id获得活动")
    @ResponseBody
    public KylinRecommendActive getActiveById(@RequestParam(name = "mid", required = true) int mid) {
        return kylinRecommendActiveService.getKylinRecommendActiveById(mid);
    }
}
