package com.liquidnet.service.goblin.dto.manage.vo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsSkuInfoVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@ApiModel(value = "GoblinStoreMgtGoodsSkuListVo", description = "商品管理:商品款式信息")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinStoreMgtGoodsSkuListVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -5926827517337445529L;
    @ApiModelProperty(position = 10, value = "店铺ID[64]")
    private String storeId;
    @ApiModelProperty(position = 10, value = "sku图")
    private String skuPic;
    @ApiModelProperty(position = 10, value = "原价格")
    private BigDecimal price;
    @ApiModelProperty(position = 11, value = "商品ID[64]")
    private String spuId;
    @ApiModelProperty(position = 12, value = "商品编码[45]")
    private String skuId;
    @ApiModelProperty(position = 14, value = "商品名称[100]")
    private String name;
    @ApiModelProperty(position = 20, value = "审核状态[0-编辑中|1-审核中|2-审核不通过|3-审核通过]")
    private String status;
    @ApiModelProperty(position = 22, value = "商品上架状态[0-待上架|1-下架|2-违规|3-上架]")
    private String shelvesStatus;
    @ApiModelProperty(position = 23, value = "总库存")
    private Integer skuStock;
    @ApiModelProperty(position = 24, value = "剩余库存")
    private Integer surplusStock;
    @ApiModelProperty(position = 27, value = "开售时间")
    private LocalDateTime saleStartTime;
    @ApiModelProperty(position = 27, value = "停售时间")
    private LocalDateTime saleStopTime;
    @ApiModelProperty(position = 33, value = "是否盲盒[0-否|1-是]")
    private String unbox;
    @ApiModelProperty(position = 34, value = "是否隐藏[0-默认展示|1-隐藏]")
    private String skuAppear;
    @ApiModelProperty(position = 35, value = "是否售罄[0-否|1-是]")
    private String soldoutStatus;
    @ApiModelProperty(position = 36, value = "是否购买[0-否|1-是]")
    private String skuCanbuy;
    @ApiModelProperty(position = 37, value = "NFT上传声明状态[0-待上传|1-已声明|2-声明失败|9-声明中]")
    private Integer upchain;
    @ApiModelProperty(position = 38, value = "盲盒命中率")
    private BigDecimal hitRatio;
    @ApiModelProperty(position = 39, value = "系统时间")
    private String sysTime;

    public String getSaleStartTime() {
        return DateUtil.Formatter.yyyyMMddHHmmss.format(saleStartTime);
    }

    public String getSaleStopTime() {
        return DateUtil.Formatter.yyyyMMddHHmmss.format(saleStopTime);
    }

    private static final GoblinStoreMgtGoodsSkuListVo obj = new GoblinStoreMgtGoodsSkuListVo();

    public static GoblinStoreMgtGoodsSkuListVo getNew() {
        try {
            return (GoblinStoreMgtGoodsSkuListVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinStoreMgtGoodsSkuListVo();
        }
    }

    public GoblinStoreMgtGoodsSkuListVo copy(GoblinGoodsSkuInfoVo source) {
        if (null == source) return this;
        this.setStoreId(source.getStoreId());
        this.setSpuId(source.getSpuId());
        this.setSkuId(source.getSkuId());
        this.setName(source.getName());
        this.setStatus(source.getStatus());
        this.setShelvesStatus(source.getShelvesStatus());
        this.setSkuStock(source.getSkuStock());
        this.setSurplusStock(source.getSurplusStock());
        this.setSaleStartTime(source.getSaleStartTime());
        this.setSaleStopTime(source.getSaleStopTime());
        this.setUnbox(source.getUnbox());
        this.setUpchain(source.getUpchain());
        this.setSkuAppear(source.getSkuAppear());
        this.setSkuCanbuy(source.getSkuCanbuy());
        this.setSoldoutStatus(source.getSoldoutStatus());
        this.setHitRatio(source.getHitRatio());
        this.setSkuPic(source.getSkuPic());
        this.setPrice(source.getPrice());
        return this;
    }
}
