package com.liquidnet.service.goblin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 手环订单表实体类
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinBraceletOrder implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 订单ID
     */
    private String orderId;

    /**
     * 用户ID
     */
    private String userId;

    /**
     * 绑定用户姓名
     */
    private String bindName;

    /**
     * 绑定用户手机号
     */
    private String bindMobile;

    /**
     * 绑定用户身份证号码
     */
    private String bindIdcard;

    /**
     * 请求日期
     */
    private String reqDate;

    /**
     * 商品描述
     */
    private String goodsDesc;

    /**
     * 手环ID
     */
    private String wristbandId;

    /**
     *手环金额
     */
    private BigDecimal wristbandPrice;

    /**
     *充值金额ID
     */
    private String amountId;

    /**
     *充值金额
     */
    private BigDecimal amountPrice;

    /**
     * 请求流水号
     */
    private String reqSeqId;

    /**
     * 全局流水号
     */
    private String hfSeqId;

    /**
     * 交易类型：
     * T_JSAPI: 微信公众号支付
     * T_MINIAPP: 微信小程序支付
     * A_JSAPI: 支付宝JS
     * A_NATIVE: 支付宝正扫
     * U_NATIVE: 银联正扫
     * U_JSAPI: 银联 JS
     * D_NATIVE: 数字人民币正扫
     * T_H5：微信直连H5支付
     * T_APP：微信APP支付
     * T_NATIVE：微信正扫
     */
    private String tradeType;


    /**
     * 用户账单上的交易订单号
     */
    private String outTransId;

    /**
     * 用户账单上的商户订单号
     */
    private String partyOrderId;

    /**
     * 支付完成时间 格式yyyyMMddHHmmss
     */
    private String endTime;

    /**
     * 入账时间 格式为yyyyMMdd
     */
    private String acctDate;

    /**
     * 单价
     */
    private BigDecimal price;

    /**
     * 应付价格
     */
    private BigDecimal priceTotal;

    /**
     * 实付价格
     */
    private BigDecimal priceActual;

    /**
     * 退款价格
     */
    private BigDecimal priceRefund;

    /**
     * 退款扣除的手续费金额
     */
    private BigDecimal refundPriceCharges;

    /**
     * 退款数
     */
    private Integer refundNumber;

    /**
     * 支付时间
     */
    private String timePay;

    /**
     * 订单状态:
     * 0 待付款
     * 1 已付款
     * 2 已关闭
     * 3 正在退款
     * 4 已退款
     * 5 待关闭
     * 6 部分退款
     * 7 退款失败
     */
    private Integer status;

    /**
     * 支付状态:
     * 0 未支付
     * 1 已支付
     * 2 支付失败
     */
    private Integer payStatus;

    /**
     * 迈之的分订单号
     */
    private String foutTradeNo;

    /**
     * 迈之的设备编号
     */
    private String cardno;

    /**
     * 迈之的分订单号
     */
    private Integer refundStatus;

    /**
     * 迈之的设备编号
     */
    private String refundStatusNote;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;

    /**
     * 备注
     */
    private String comment;
}
