package com.liquidnet.service.sweet.controller;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.param.SweetLostFoundAdminParam;
import com.liquidnet.service.sweet.param.ValidationGroups;
import com.liquidnet.service.sweet.service.ISweetLostFoundAdminService;
import com.liquidnet.service.sweet.vo.SweetLostFoundAdminVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 失物招领管理员Controller
 *
 * @author liquidnet
 * @since 2025-01-18
 */
@RestController
@RequestMapping("/lost-found/admin")
@Api(value = "失物招领管理员管理", tags = "失物招领管理员管理")
@Validated
public class SweetLostFoundAdminController {

    @Autowired
    private ISweetLostFoundAdminService sweetLostFoundAdminService;

    @PostMapping("/add")
    @ApiOperation("添加管理员")
    public ResponseDto<Boolean> addAdmin(@RequestBody @Validated SweetLostFoundAdminParam admin) {
        return ResponseDto.success(sweetLostFoundAdminService.addAdmin(admin));
    }

    @PutMapping("/update")
    @ApiOperation("编辑管理员")
    public ResponseDto<Boolean> updateAdmin(@RequestBody @Validated({ValidationGroups.Update.class}) SweetLostFoundAdminParam admin) {
        return ResponseDto.success(sweetLostFoundAdminService.editAdmin(admin));
    }

    @DeleteMapping("/delete/{id}")
    @ApiOperation("删除管理员")
    public ResponseDto<Boolean> deleteAdmin(
            @ApiParam("管理员ID") @PathVariable Long id) {
        return ResponseDto.success(sweetLostFoundAdminService.deleteAdmin(id));
    }

    @GetMapping("/detail/{id}")
    @ApiOperation("获取管理员详情")
    public ResponseDto<SweetLostFoundAdminVo> getAdminDetail(
            @ApiParam("管理员ID") @PathVariable Long id) {
        return ResponseDto.success(sweetLostFoundAdminService.getAdminDetail(id));
    }

    @GetMapping("/list/{performanceId}")
    @ApiOperation("获取管理员列表")
    public ResponseDto<List<SweetLostFoundAdminVo>> getAdminList(@ApiParam("演出ID") @PathVariable String performanceId) {
        return ResponseDto.success(sweetLostFoundAdminService.getAdminList(performanceId));
    }

    @GetMapping("/permission/{phone}/{performanceId}")
    @ApiOperation("获取权限")
    public ResponseDto<SweetLostFoundAdminVo> getPermission(
            @ApiParam("手机号") @PathVariable String phone,
            @ApiParam("演出ID") @PathVariable String performanceId) {
        return ResponseDto.success(sweetLostFoundAdminService.hasPermission(phone, performanceId));
    }
}