package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.time.LocalDateTime;

@ApiModel(value = "GoblinNftOrderArtworkInfoVo", description = "NFT订单中藏品信息")
@Data
public class GoblinNftOrderArtworkInfoVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 5307265664272864863L;
    @ApiModelProperty(position = 10, value = "商品单品ID")
    private String artworkId;
    @ApiModelProperty(position = 11, value = "是否盲盒[0-否|1-是]")
    private String unbox;
    @ApiModelProperty(position = 12, value = "藏品状态，根据`unbox`区分盲盒来判断[0-生成中/未开启|1-已生成/已开启|2-生成失败/开启失败|5-待收取]")
    private Integer state;
    @ApiModelProperty(position = 13, value = "转赠状态[PENDING|SUCCESS]，为空代表未发生转赠")
    private String transferState;
    @ApiModelProperty(position = 14, value = "受赠人信息")
    private String receiverUser;
    @ApiModelProperty(position = 15, value = "藏品转赠时间[yyyy-MM-dd HH:mm:ss]")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime transferTime;

    private static final GoblinNftOrderArtworkInfoVo obj = new GoblinNftOrderArtworkInfoVo();

    public static GoblinNftOrderArtworkInfoVo getNew() {
        return obj.clone();
    }

    @Override
    public GoblinNftOrderArtworkInfoVo clone() {
        try {
            return (GoblinNftOrderArtworkInfoVo) super.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinNftOrderArtworkInfoVo();
        }
    }

    public GoblinNftOrderArtworkInfoVo copy(GoblinUserDigitalArtworkVo source) {
        if (null == source) return this;
        this.setArtworkId(source.getArtworkId());
        this.setState(source.getState());
        this.setTransferState(source.getTransferState());
        if (StringUtils.isNotEmpty(source.getTransferState())) {
            this.setReceiverUser(source.getReceiverUser());
            this.setTransferTime(source.getUpdatedAt());
        }
        return this;
    }
}
