package com.liquidnet.service.adam.config;

import com.liquidnet.common.web.config.WebMvcConfig;
import com.liquidnet.service.adam.interceptor.AdamAuthorityInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;

@Configuration
public class AdamWebMvcConfig extends WebMvcConfig {
    @Autowired
    AdamAuthorityInterceptor adamAuthorityInterceptor;

    @Override
    protected void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(adamAuthorityInterceptor).addPathPatterns("/**");
        super.addInterceptors(registry);
    }
}
