package com.liquidnet.service.goblin.dto.manage;

import com.liquidnet.commons.lang.constant.LnsRegex;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.io.Serializable;
import java.util.List;

@ApiModel(value = "GoblinStoreMgtCouponAddParam", description = "商铺活动:添加优惠券入参")
@Data
public class GoblinStoreMgtCouponAddParam implements Serializable {
    private static final long serialVersionUID = 4211658816582135860L;
    @ApiModelProperty(position = 10, required = true, value = "店铺ID")
    @NotNull(message = "店铺ID不能为空")
    private String storeId;
    @ApiModelProperty(position = 11, required = false, value = "优惠券ID[编辑时必传]")
    private String storeCouponId;

    /**
     * ---------------------------- 基本信息 ----------------------------
     **/

    @ApiModelProperty(position = 12, required = true, value = "卡券名称[50]")
    @NotBlank(message = "卡券名称不能为空")
    @Size(max = 50, message = "商品名称长度超限")
    private String title;
    @ApiModelProperty(position = 13, required = false, value = "标注[50]")
    @Size(max = 50, message = "标注长度超限")
    private String label;
    @ApiModelProperty(position = 14, required = false, value = "卡券描述[255]")
    @Size(max = 255, message = "卡券描述长度超限")
    private String notice;

    @ApiModelProperty(position = 15, required = true, value = "开始时间[yyyy-MM-dd HH:mm:ss]")
    @NotBlank(message = "发布时间不能为空")
    @Pattern(regexp = LnsRegex.Valid.DATETIME_FULL, message = "开始时间格式有误")
    private String startDt;
    @ApiModelProperty(position = 16, required = true, value = "开始时间[yyyy-MM-dd HH:mm:ss]")
    @NotBlank(message = "发布时间不能为空")
    @Pattern(regexp = LnsRegex.Valid.DATETIME_FULL, message = "开始时间格式有误")
    private String endDt;

    @ApiModelProperty(position = 17, required = true, value = "卡券类型信息LIST")
    @NotNull(message = "卡券类型信息不能为空")
    @Valid
    private List<GoblinStoreMgtCouponAddType> couponTypeParamList;

    @ApiModelProperty(position = 18, required = true, value = "限领数量，默认：1张/人", example = "1")
    @Min(value = 1, message = "限领数量不能小于1")
    private Integer receiveLimit;
    @ApiModelProperty(position = 19, required = true, value = "领取约束[0-不开放|1-开放]", allowableValues = "0,1")
    @Pattern(regexp = "\\b(0|1)\\b", message = "领取约束参数无效")
    private Integer receiveCurb;

    /**
     * ---------------------------- 发放设置 ----------------------------
     **/

    @ApiModelProperty(position = 20, required = true, value = "使用范围[0-全部商品|1-部分商品]", allowableValues = "0,1", example = "0")
    private String useScope;
    @ApiModelProperty(position = 21, required = false, value = "适用商品集合LIST")
    @Valid
    private List<GoblinStoreMgtCouponAddGoods> skuParamList;
}
