package com.liquidnet.service.goblin.dto.manage.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsInfoVo;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsSkuInfoVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@ApiModel(value = "GoblinStoreMgtCouponInfoVo", description = "商铺活动:优惠券详情")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinStoreMgtCouponInfoVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -5779799640116243874L;
    @ApiModelProperty(position = 10, value = "卡券ID[64]")
    private String storeCouponId;
    @ApiModelProperty(position = 11, value = "卡券编码")
    private String storeCouponNo;
    @ApiModelProperty(position = 12, value = "店铺ID")
    private String storeId;
    @ApiModelProperty(position = 13, value = "卡券名称")
    private String title;
    @ApiModelProperty(position = 14, value = "标注")
    private String label;
    @ApiModelProperty(position = 15, value = "卡券描述")
    private String notice;
    @ApiModelProperty(position = 16, value = "券类型[1-代金券|2-折扣券|3-满减券]")
    private Integer type;
    @ApiModelProperty(position = 17, value = "卡券库存，默认：0为无限")
    private Integer stock;
    @ApiModelProperty(position = 18, value = "触发金额")
    private BigDecimal triggers;
    @ApiModelProperty(position = 19, value = "面值")
    private BigDecimal valFace;
    @ApiModelProperty(position = 20, value = "折扣[8折即0.8]")
    private BigDecimal discount;
    @ApiModelProperty(position = 21, value = "满减~满")
    private BigDecimal valOver;
    @ApiModelProperty(position = 22, value = "满减~减")
    private BigDecimal valMinus;
    @ApiModelProperty(position = 23, value = "抵扣上限金额（最多扣除金额）")
    private BigDecimal deduction;
    @ApiModelProperty(position = 24, value = "限领数量，默认：1张/人")
    private Integer receiveLimit;
    @ApiModelProperty(position = 25, value = "领取约束[0-不开放|1-开放]")
    private Integer receiveCurb;
    @ApiModelProperty(position = 26, value = "使用范围[0-全部商品|1-部分商品]")
    private Integer useScope;
    @ApiModelProperty(position = 27, value = "卡券状态[0-等待开始|1-活动中|2-活动结束|3-停用]")
    private Integer state;
    @ApiModelProperty(position = 28, value = "开始时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime startTime;
    @ApiModelProperty(position = 14, value = "结束时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern=DateUtil.DATE_FULL_STR)
    private LocalDateTime endTime;


    private static final GoblinStoreMgtCouponInfoVo obj = new GoblinStoreMgtCouponInfoVo();
    public static GoblinStoreMgtCouponInfoVo getNew() {
        try {
            return (GoblinStoreMgtCouponInfoVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinStoreMgtCouponInfoVo();
        }
    }
}
