package com.liquidnet.service.platform.controller.basicServices;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.adam.dto.vo.admin.AdminUpushVo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.platform.service.basicServices.AdminUpushServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 友盟推送 系统消息
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-07-15
 */
@Api(tags = "basicServices")
@RestController
@RequestMapping("basicServices/upush")
public class AdminUpushController {

    @Autowired
    private AdminUpushServiceImpl adminUpushServiceImpl;

    @GetMapping("system")
    @ApiOperation("系统消息列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "page", value = "页码"),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "size", value = "每页数量"),
    })
    public ResponseDto<PageInfo<AdminUpushVo>> lists(
            @RequestParam(defaultValue = "1") Integer page,
            @RequestParam(defaultValue = "10") Integer size
    ) {
        PageInfo<AdminUpushVo> result = adminUpushServiceImpl.lists(page, size);

        return ResponseDto.success(result);
    }

}
