package com.liquidnet.service.sweet.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.commons.lang.util.BeanUtil;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ErrorMapping;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.dto.SweetManualDto;
import com.liquidnet.service.sweet.entity.SweetManual;
import com.liquidnet.service.sweet.entity.SweetStage;
import com.liquidnet.service.sweet.mapper.SweetManualMapper;
import com.liquidnet.service.sweet.mapper.SweetStageMapper;
import com.liquidnet.service.sweet.service.ISweetManualService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.service.sweet.utils.RedisDataUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;

/**
 * <p>
 * 电子宣传手册表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-07-23
 */
@Service
public class SweetManualServiceImpl extends ServiceImpl<SweetManualMapper, SweetManual> implements ISweetManualService {

    @Autowired
    private SweetManualMapper sweetManualMapper;
    @Autowired
    private RedisDataUtils redisDataUtils;

    @Override
    public ResponseDto<PageInfo<SweetManualDto>> getManualList(int page, int size, String name) {
        PageInfo<SweetManualDto> pageInfoTmp;
        try {
            PageHelper.startPage(page, size);
            HashMap<String, Object> map = CollectionUtil.mapStringObject();
            map.put("title", name);
            List<SweetManualDto> voList = sweetManualMapper.getManualList(BeanUtil.convertBeanToMap(map));
            for (int i = 0; i < voList.size(); i++) {
                SweetManualDto vo = voList.get(i);
                if (vo.getStatus() >= 6 && vo.getStatus() != 7) {
                    if (DateUtil.compareStrDay(vo.getTimeSell(), DateUtil.getNowTime()) > 0) {//未开始
                        vo.setStatus(9);
                    } else if (DateUtil.compareStrDay(vo.getTimeStop(), DateUtil.getNowTime()) < 0) {//已结束
                        vo.setStatus(10);
                    } else {
                        vo.setStatus(6);
                    }
                }
            }
            pageInfoTmp = new PageInfo(voList);
        } catch (Exception e) {
            e.printStackTrace();
            return ResponseDto.failure(ErrorMapping.get(20104));
        }
        return ResponseDto.success(pageInfoTmp);
    }

    @Override
    public ResponseDto<Boolean> changeStatus(String manualId, String performancesId, Integer status) {
        try {
            int count = sweetManualMapper.selectCount(Wrappers.lambdaUpdate(SweetManual.class).eq(SweetManual::getManualId, manualId));
            SweetManual sweetManual = SweetManual.getNew();
            if (count > 0) {//修改
                sweetManual.setStatus(status);
                sweetManual.setUpdatedAt(LocalDateTime.now());
                sweetManualMapper.update(sweetManual, Wrappers.lambdaUpdate(SweetManual.class).eq(SweetManual::getManualId, manualId));
            } else {//创建
                sweetManual.setManualId(IDGenerator.nextSnowId());
                sweetManual.setPerformanceId(performancesId);
                sweetManual.setStatus(status);
                sweetManual.setIsRelease(0);
                sweetManual.setCreatedAt(LocalDateTime.now());
                sweetManualMapper.insert(sweetManual);
            }
        } catch (Exception e) {
            return ResponseDto.failure();
        }
        redisDataUtils.deletePushListRedisData();
        return ResponseDto.success();
    }

    @Override
    public ResponseDto<Boolean> changeRelease(String manualId, Integer isRelease) {
        try {
            SweetManual sweetManual = SweetManual.getNew();
            sweetManual.setIsRelease(isRelease);
            sweetManual.setUpdatedAt(LocalDateTime.now());
            sweetManualMapper.update(sweetManual, Wrappers.lambdaUpdate(SweetManual.class).eq(SweetManual::getManualId, manualId));
        } catch (Exception e) {
            return ResponseDto.failure();
        }
        redisDataUtils.deletePushListRedisData();
        return ResponseDto.success();
    }
}
