package com.liquidnet.client.admin.web.controller.zhengzai.adam;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.client.admin.zhengzai.adam.service.IAdamMemberOrderAdminService;
import com.liquidnet.service.adam.dto.MemberOrderDto;
import com.liquidnet.service.adam.dto.admin.AdamMemberOrderRefundParam;
import com.liquidnet.service.adam.dto.admin.MemberOrderListReq;
import com.liquidnet.service.adam.dto.vo.admin.MemberOrderDetailAdminVo;
import com.liquidnet.service.adam.entity.AdamMemberOrder;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 会员订单Controller
 * @class: Test
 * @Package com.liquidnet.client.admin.web.controller.zhengzai.adam
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/6/6 16:52
 */
@Controller
@RequestMapping("adam/order")
public class AdamMemberOrderAdminController extends BaseController {
    private String prefix = "zhengzai/adam/order";

    @Autowired
    private IAdamMemberOrderAdminService adamMemberOrderAdminService;

    @RequiresPermissions("adam:order:orderlist:view")
    @GetMapping("/orderList")
    public String order() {
        return prefix + "/orderList/order";
    }

    @Log(title = "会员订单列表", businessType = BusinessType.LIST)
    @RequiresPermissions("adam:order:orderlist:list")
    @PostMapping("/orderList/list")
    @ResponseBody
    public TableDataInfo list(MemberOrderListReq memberOrderListReq) {
        startPage();
        List<MemberOrderDto> list = adamMemberOrderAdminService.getMemberOrderList(memberOrderListReq);
        return getDataTable(list);
    }

    @Log(title = "会员订单详情", businessType = BusinessType.DETAIL)
    @RequiresPermissions("adam:order:orderlist:detail")
    @GetMapping("/orderList/detail/{orderId}")
    public String orderDetail(@PathVariable("orderId") String orderId, ModelMap mmap) {
        MemberOrderDetailAdminVo orderDetailsVo = adamMemberOrderAdminService.getMemberOrderDetail(orderId);
        mmap.put("orderDetailsVo", orderDetailsVo);
        return prefix + "/orderList/detail";
    }

    @Log(title = "会员订单退款", businessType = BusinessType.MORDER_REFUND)
    @RequiresPermissions("adam:order:orderlist:refund")
    @PostMapping("/orderList/refund")
    @ResponseBody
    public AjaxResult orderRefund(@Validated AdamMemberOrderRefundParam parameter) {
        LambdaQueryWrapper<AdamMemberOrder> queryWrapper = Wrappers.lambdaQuery(AdamMemberOrder.class)
                .eq(AdamMemberOrder::getOrderNo, parameter.getOrderNo());
        AdamMemberOrder memberOrder = adamMemberOrderAdminService.getOne(queryWrapper);

        if (null == memberOrder) {
            return this.error("订单不存在");
        }
        if (memberOrder.getPricePaid().compareTo(parameter.getRefundAmt()) < 0) {
            return this.error("退款金额超出订单实际支付金额");
        }

        return this.toAjax(adamMemberOrderAdminService.refundProcessing(parameter, memberOrder));
    }
}
