package com.liquidnet.service.sweet.controller;


import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.dto.SweetManualDto;
import com.liquidnet.service.sweet.entity.SweetStage;
import com.liquidnet.service.sweet.service.ISweetManualService;
import com.liquidnet.service.sweet.service.ISweetManualSortService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 电子宣传手册表 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-07-23
 */
@Api(tags = "电子手册")
@RestController
@RequestMapping("/sweet-manual")
public class SweetManualController {

    @Autowired
    private ISweetManualService sweetManualService;

    @GetMapping("list")
    @ApiOperation("宣传手册列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "page", value = "页数", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "size", value = "数量", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "name", value = "姓名", required = true),
    })
    public ResponseDto<PageInfo<SweetManualDto>> getList(@RequestParam(defaultValue = "1") Integer page,
                                                         @RequestParam(defaultValue = "10") Integer size,
                                                         @RequestParam(defaultValue = "") String name) {
        return sweetManualService.getManualList(page, size, name);
    }

    @GetMapping("changeRelease")
    @ApiOperation("修改是否发布")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "page", value = "页数", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "size", value = "数量", required = true),
    })
    public ResponseDto<Boolean> changeRelease(@RequestParam(defaultValue = "1") String manualId,
                                              @RequestParam(defaultValue = "1") Integer isRelease) {
        return sweetManualService.changeRelease(manualId, isRelease);
    }

    @GetMapping("changeStatus")
    @ApiOperation("修改是否开启")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "电子手册id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "performancesId", value = "演出id", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "status", value = "开启状态", required = true),
    })
    public ResponseDto<Boolean> changeStatus(@RequestParam(defaultValue = "1") String manualId,
                                             @RequestParam(defaultValue = "1") String performancesId,
                                             @RequestParam(defaultValue = "1") Integer status) {
        return sweetManualService.changeStatus(manualId, performancesId, status);
    }

}
