/**
 * $Id$
 * Copyright(C) 2015-2020 kowlone - internet center, All Rights Reserved.
 */
package com.liquidnet.commons.lang.keywords;

/**
 * 关键词过滤
 * @author <a href="kowlone2006@163.com">kowlone</a>
 * @version 1.0 2015年09月14日 15:37:00
 */
public interface IKeywordsFilter {

	/**
	 * 使用关键字列表进行初始化
	 *
	 * @param keyWords  关键字列表
	 * @return 是否初始化成功，成功true，否则false
	 */
	boolean initialize(String[] keyWords);

	/**
	 * 过滤关键词
	 *
	 * @param  s 要被处理的字符串
	 * @return 处理完毕的被过滤的字符串
	 */
	String filter(String s);

	/**
	 * 检测输入的消息是否有关键字
	 *
	 * @param inputMsg  要检测的消息
	 * @return 若有返回true，否则false
	 */
	boolean contain(String inputMsg);
}
