package com.liquidnet.service.kylin.dto.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.List;

@Data
public class PayOrderParam {
    @ApiModelProperty(value = "演出id")
    @NotNull(message = "必传")
    private String performanceId;
    @ApiModelProperty(value = "场次id")
    @NotNull(message = "必传")
    private String timeId;
    @ApiModelProperty(value = "票种id")
    @NotNull(message = "必传")
    private String ticketId;
    @ApiModelProperty(value = "数量")
    @NotNull(message = "必传")
    private Integer number;

//    @ApiModelProperty(value = "是否学生票")
//    @NotNull(message = "必传")
//    private Integer isStudent;
    @ApiModelProperty(value = "是否电子票")
    @NotNull(message = "必传")
    private Integer isElectronic;
    @ApiModelProperty(value = "是否快递票")
    @NotNull(message = "必传")
    private Integer isExpress;

    @ApiModelProperty(value = "收货地址id")
    private String addressId;
    @ApiModelProperty(value = "入场人id数组")
    private List<String> enterIdList;
    @ApiModelProperty(value = "代理id")
    @NotNull(message = "必传")
    private String agentId;
    @ApiModelProperty(value = "快递类型 1寄付 2到付")
    @NotNull(message = "必传")
    private Integer expressType;


    @ApiModelProperty(value = "支付类型")
    @NotNull(message = "必传")
    private String payType;
    @ApiModelProperty(value = "支付来源")
    @NotNull(message = "必传")
    private String deviceFrom;
    @ApiModelProperty(value = "openId")
    private String openId;
    @ApiModelProperty(value = "showUrl")
    private String showUrl;
    @ApiModelProperty(value = "returnUrl")
    private String returnUrl;
}
