package com.liquidnet.service.merchant.service;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.merchant.constant.MerchantRedisConst;
import com.liquidnet.service.merchant.dto.vo.MerchantFieldAppliesVo;
import com.liquidnet.service.merchant.dto.vo.MerchantFieldsVo;
import com.liquidnet.service.merchant.util.ObjectUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Slf4j
@Service
public class MerchantRdmService {

    @Autowired
    RedisUtil redisUtil;

    public MerchantFieldsVo getFieldsVoByFieldId(String fieldId) {
        String key = MerchantRedisConst.INFO_FIELD.concat(fieldId);
        long s = System.currentTimeMillis();
        MerchantFieldsVo vo = (MerchantFieldsVo) redisUtil.get(key);
        log.debug("#RDM耗时:{}ms", System.currentTimeMillis() - s);
        return vo;
    }

    public boolean setFieldsVoByFieldId(String fieldId, MerchantFieldsVo vo) {
        return redisUtil.set(MerchantRedisConst.INFO_FIELD.concat(fieldId), vo);
    }


    public List<MerchantFieldAppliesVo> getFieldsAppliesVosByUid(String uid) {
        String key = MerchantRedisConst.INFO_FIELD_APPLIES.concat(uid);
        long s = System.currentTimeMillis();
        List<MerchantFieldAppliesVo> vos = (List<MerchantFieldAppliesVo>) redisUtil.get(key);
        log.debug("#RDM耗时:{}ms", System.currentTimeMillis() - s);
        return vos;
    }

    public boolean addFieldsAppliesVoByUid(String uid, List<MerchantFieldAppliesVo> vos, MerchantFieldAppliesVo vo) {
        if (null == vos) {
            vos = ObjectUtil.getMerchantFieldAppliesVoArrayList();
        }
        vos.add(vo);
        return redisUtil.set(MerchantRedisConst.INFO_FIELD_APPLIES.concat(uid), vos);
    }


}
