package com.liquidnet.service.sweet.controller;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.entity.SweetArtists;
import com.liquidnet.service.sweet.entity.SweetPerformanceShow;
import com.liquidnet.service.sweet.service.ISweetPerformanceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDateTime;

@Api(tags = "演出AR")
@RestController
@RequestMapping("/sweet-ar")
public class SweetPerformanceController {
    @Autowired
    private ISweetPerformanceService sweetPerformanceService;


    @GetMapping("list")
    @ApiOperation("ar列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "page", value = "页数", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "size", value = "数量", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "performanceName", value = "演出名", required = false),
    })
    public ResponseDto<PageInfo<SweetPerformanceShow>> getList(@RequestParam() Integer page,
                                                       @RequestParam() Integer size,
                                                       @RequestParam(required = false) String performanceName) {
        return sweetPerformanceService.getList(page, size, performanceName);
    }



    @PostMapping("add")
    @ApiOperation("添加")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "performanceId", value = "演出id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "performanceName", value = "演出名", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "picOne", value = "图片1", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "picTwo", value = "图片2", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "arUrl", value = "AR地址", required = true),
            @ApiImplicitParam(type = "query", dataType = "LocalDateTime", name = "timeStart", value = "开始时间", required = true),
            @ApiImplicitParam(type = "query", dataType = "LocalDateTime", name = "timeEnd", value = "结束时间", required = true)
    })
    public ResponseDto<Boolean> add(@RequestParam() String performanceId,
                                    @RequestParam() String performanceName,
                                    @RequestParam() String picOne,
                                    @RequestParam() String picTwo,
                                    @RequestParam() String arUrl,
                                    @RequestParam() String timeStart,
                                    @RequestParam() String timeEnd) {
        return sweetPerformanceService.add(performanceId,performanceName,picOne, picTwo, arUrl, timeStart,timeEnd);
    }

    @PostMapping("change")
    @ApiOperation("修改")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "performanceId", value = "演出id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "picOne", value = "图片1", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "picTwo", value = "图片2", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "arUrl", value = "AR地址", required = true),
            @ApiImplicitParam(type = "query", dataType = "LocalDateTime", name = "timeStart", value = "开始时间", required = true),
            @ApiImplicitParam(type = "query", dataType = "LocalDateTime", name = "timeEnd", value = "结束时间", required = true)
    })
    public ResponseDto<Boolean> change(SweetPerformanceShow show) {
        return sweetPerformanceService.change(show);
    }

    @PostMapping("del")
    @ApiOperation("删除")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "performanceId", value = "演出id", required = true)
    })
    public ResponseDto<Boolean> del(  @RequestParam() String performanceId) {
            return sweetPerformanceService.del(performanceId);
    }


}
