package com.liquidnet.service.sweet.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.dto.SweetManualArtistList2Dto;
import com.liquidnet.service.sweet.dto.SweetManualArtistListDto;
import com.liquidnet.service.sweet.dto.SweetManualArtistStageListDto;
import com.liquidnet.service.sweet.entity.*;
import com.liquidnet.service.sweet.mapper.SweetArtistsMapper;
import com.liquidnet.service.sweet.mapper.SweetArtistsUrlMapper;
import com.liquidnet.service.sweet.mapper.SweetManualArtistsMapper;
import com.liquidnet.service.sweet.mapper.SweetStageMapper;
import com.liquidnet.service.sweet.service.ISweetArtistsService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.service.sweet.utils.RedisDataUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 艺人表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-07-23
 */
@Service
public class SweetArtistsServiceImpl extends ServiceImpl<SweetArtistsMapper, SweetArtists> implements ISweetArtistsService {

    @Autowired
    private SweetArtistsMapper sweetArtistsMapper;
    @Autowired
    private SweetManualArtistsMapper sweetManualArtistsMapper;
    @Autowired
    private RedisDataUtils redisDataUtils;
    @Autowired
    private SweetArtistsUrlMapper sweetArtistsUrlMapper;


    @Override
    public ResponseDto<PageInfo<SweetArtists>> getList(int page, int size, String name) {
        PageInfo<SweetArtists> pageInfo = null;
        try {
            List<SweetArtists> data;
            PageHelper.startPage(page, size);
            if(name!=null){
                 data = sweetArtistsMapper.selectList(Wrappers.lambdaQuery(SweetArtists.class).like(SweetArtists::getName, name));
                for (SweetArtists sweetArtists : data) {
                    String artistsId = sweetArtists.getArtistsId();
                    List<SweetArtistsUrl> sweetArtistsUrl = sweetArtistsUrlMapper.selectList(Wrappers.lambdaQuery(SweetArtistsUrl.class).eq(SweetArtistsUrl::getArtistsId, artistsId));
                    sweetArtists.setSweetArtistsUrl(sweetArtistsUrl);
                }
            }else{
                 data = sweetArtistsMapper.selectList(Wrappers.lambdaQuery(SweetArtists.class));
                for (SweetArtists sweetArtists : data) {
                    String artistsId = sweetArtists.getArtistsId();
                    List<SweetArtistsUrl> sweetArtistsUrl = sweetArtistsUrlMapper.selectList(Wrappers.lambdaQuery(SweetArtistsUrl.class).eq(SweetArtistsUrl::getArtistsId, artistsId));
                    sweetArtists.setSweetArtistsUrl(sweetArtistsUrl);
                }
            }
            pageInfo = new PageInfo(data);
            return ResponseDto.success(pageInfo);
        } catch (Exception e) {
            return ResponseDto.success(pageInfo);
        }
    }

    @Override
    @Transactional
    public ResponseDto<Boolean> add(SweetArtistsList sweetArtistsList) {
        try {
            String mid = IDGenerator.nextSnowId();
            LocalDateTime time = LocalDateTime.now();
            SweetArtistsUrl sweetArtistsUrl= SweetArtistsUrl.getNew();
            SweetArtists sweetArtists = SweetArtists.getNew();
            sweetArtists.setArtistsId(mid);
            sweetArtists.setName(sweetArtistsList.getName());
            sweetArtists.setPinyin(sweetArtistsList.getPinyin());
            sweetArtists.setDescribes(sweetArtistsList.getDescribes());
            sweetArtists.setCreatedAt(time);
            sweetArtists.setUpdatdAt(time);
            sweetArtistsMapper.insert(sweetArtists);
            sweetArtistsUrl.setArtistsId(mid);
            sweetArtistsUrl.setCreatedAt(time);
            for (String img : sweetArtistsList.getPicArray()) {
                sweetArtistsUrl.setUrl(img);
                sweetArtistsUrl.setType("1");
                sweetArtistsUrlMapper.insert(sweetArtistsUrl);
            }
            for (String video : sweetArtistsList.getVideoArray()) {
                sweetArtistsUrl.setUrl(video);
                sweetArtistsUrl.setType("2");
                sweetArtistsUrlMapper.insert(sweetArtistsUrl);
            }
            return ResponseDto.success();
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<SweetArtists> detail(String artistsId) {
        try {
            SweetArtists sweetArtists = sweetArtistsMapper.selectOne(Wrappers.lambdaQuery(SweetArtists.class).eq(SweetArtists::getArtistsId, artistsId));
            List<SweetArtistsUrl> sweetArtistsUrl = sweetArtistsUrlMapper.selectList(Wrappers.lambdaQuery(SweetArtistsUrl.class).eq(SweetArtistsUrl::getArtistsId, artistsId));

            sweetArtists.setSweetArtistsUrl(sweetArtistsUrl);
            return ResponseDto.success(sweetArtists);
        } catch (Exception e) {
            log.error("==",e);
            return ResponseDto.failure();
        }
    }

    @Override
    @Transactional
    public ResponseDto<Boolean> change(String artistsId,SweetArtistsList sweetArtistsList) {
        try {

            LocalDateTime time = LocalDateTime.now();
            SweetArtists sweetArtists = SweetArtists.getNew();
            sweetArtists.setName(sweetArtistsList.getName());
            sweetArtists.setPinyin(sweetArtistsList.getPinyin());
            sweetArtists.setDescribes(sweetArtistsList.getDescribes());
            sweetArtists.setUpdatdAt(time);
            SweetArtistsUrl sweetArtistsUrl = SweetArtistsUrl.getNew();
            sweetArtistsUrl.setCreatedAt(time);
            sweetArtistsMapper.update(sweetArtists, Wrappers.lambdaUpdate(SweetArtists.class).eq(SweetArtists::getArtistsId, artistsId));
            //更新关联表
            sweetArtistsUrlMapper.delete(Wrappers.lambdaQuery(SweetArtistsUrl.class).eq(SweetArtistsUrl::getArtistsId, artistsId));
            sweetArtistsUrl.setArtistsId(artistsId);
            sweetArtistsUrl.setCreatedAt(time);
            for (String img : sweetArtistsList.getPicArray()) {
                sweetArtistsUrl.setUrl(img);
                sweetArtistsUrl.setType("1");
                sweetArtistsUrlMapper.insert(sweetArtistsUrl);
            }
            for (String video : sweetArtistsList.getVideoArray()) {
                sweetArtistsUrl.setUrl(video);
                sweetArtistsUrl.setType("2");
                sweetArtistsUrlMapper.insert(sweetArtistsUrl);
            }
            List<SweetManualArtists> data = sweetManualArtistsMapper.selectList(Wrappers.lambdaQuery(SweetManualArtists.class).eq(SweetManualArtists::getArtistsId, artistsId));
            for (SweetManualArtists item : data) {
                redisDataUtils.deleteTimeListRedisData(item.getManualId());
            }
            return ResponseDto.success();
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    @Transactional
    public ResponseDto<SweetArtists> del(String artistsId) {
        try {
            sweetArtistsMapper.delete(Wrappers.lambdaQuery(SweetArtists.class).eq(SweetArtists::getArtistsId, artistsId));
            sweetArtistsUrlMapper.delete(Wrappers.lambdaQuery(SweetArtistsUrl.class).eq(SweetArtistsUrl::getArtistsId, artistsId));
            return ResponseDto.success();
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }


}
