package com.liquidnet.service.sweet.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.entity.SweetPerformanceShow;
import com.liquidnet.service.sweet.mapper.SweetPerformanceMapper;
import com.liquidnet.service.sweet.service.ISweetPerformanceAppService;
import com.liquidnet.service.sweet.utils.RedisDataUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
@Service
public class SweetPerformanceAppServiceImpl extends ServiceImpl<SweetPerformanceMapper, SweetPerformanceShow> implements ISweetPerformanceAppService {
    @Autowired
    private RedisDataUtils redisUtils;

    @Override
    public ResponseDto<PageInfo<SweetPerformanceShow>> getlistInTime(Integer page, Integer size) {
        PageInfo<SweetPerformanceShow> pageInfo = null;

        try {
            List<SweetPerformanceShow> data = new ArrayList<>();
            PageHelper.startPage(page, size);
            LocalDateTime time = LocalDateTime.now();
           /* data = sweetPerformanceMapper.selectList(Wrappers.lambdaQuery(SweetPerformanceShow.class)
                    .le(SweetPerformanceShow::getTimeStart,time).ge(SweetPerformanceShow::getTimeEnd,time).eq(SweetPerformanceShow::getStatus,1));*/
            List<SweetPerformanceShow> performanceARList = redisUtils.getPerformanceAR();
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            for (SweetPerformanceShow performanceShow : performanceARList) {
                String timeStart =performanceShow.getTimeStart().replace("T"," ");
                String timeEnd = performanceShow.getTimeEnd().replace("T", " ");
                LocalDateTime startTime = LocalDateTime.parse(performanceShow.getTimeStart());
                LocalDateTime endTime = LocalDateTime.parse(performanceShow.getTimeEnd());
                if (startTime.isBefore(time) && endTime.isAfter(time)){
                    data.add(performanceShow);
                }
            }
            pageInfo = new PageInfo(data);
            return ResponseDto.success(pageInfo);
        }catch (Exception e) {
            return ResponseDto.success(pageInfo);
        }

    }
}
