package com.liquidnet.service.chime.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.chime.dto.ChimeUserInfoDto;
import com.liquidnet.service.chime.dto.ChimeUserRegisterReqDto;
import com.liquidnet.service.chime.dto.ChimeUserUpdateReqDto;
import com.liquidnet.service.chime.service.IChimeUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 社交用户控制类
 * @class: ChimeUserController
 * @Package com.liquidnet.service.chime.controller
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/9/8 15:43
 */
@Api(tags = "在场-用户相关")
@RestController
@RequestMapping("user")
@Validated
@Slf4j
public class ChimeUserController {
    @Autowired
    private IChimeUserService chimeUserService;

    @ApiOperationSupport(order = 5)
    @ApiOperation(value = "社交用户注册")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "userId", value = "用户id"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "sex", value = "性别"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "tags", value = "兴趣标签[{\"val\":\"tag1\",\"desc\":\"tag描述\"},{\"val\":\"tag2\",\"desc\":\"tag描述2\"}]"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "operateType", value = "CREATE,UPDATE"),
    })
    @PostMapping(value = {"register"})
    public ResponseDto<String> register(@RequestParam @Validated String userId
            , @RequestParam @Validated String sex
            , @RequestParam @Validated String tags
            , @RequestParam @Validated String operateType
    ) {
        if(operateType.equalsIgnoreCase("CREATE")){
            ChimeUserRegisterReqDto reqDto = ChimeUserRegisterReqDto.getNew();
            reqDto.setUserId(userId);
            reqDto.setSex(sex);
            reqDto.setTags(tags);
            ChimeUserInfoDto chimeUserInfoDto = chimeUserService.createChimeUserInfo(reqDto);
            if(StringUtil.isNull(chimeUserInfoDto)){
                return ResponseDto.failure("chime创建社交用户失败！");
            }
            return ResponseDto.success("创建成功！");
        }else if(operateType.equalsIgnoreCase("UPDATE")) {
            ChimeUserUpdateReqDto reqDto = ChimeUserUpdateReqDto.getNew();
            reqDto.setUserId(userId);
            reqDto.setSex(sex);
            reqDto.setTags(tags);
            //更新用户信息
            Boolean rs = chimeUserService.updateUserInfo(reqDto);
            if(!rs){
                return ResponseDto.failure("更新社交用户信息失败！");
            }
            return ResponseDto.success(rs.toString());
        }
        return null;
    }
}
