package com.liquidnet.service.goblin.dto.vo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 可参加官方活动的店铺表
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-28
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinMarketingZhengzaiRelationVo implements Serializable, Cloneable {
    @ApiModelProperty(value = "官方营销表id")
    private String selfMarketId;
    @ApiModelProperty(value = "商铺id")
    private String storeId;
    @ApiModelProperty(value = "可显示时间")
    private String showTime;
    @ApiModelProperty(value = "创建时间")
    private String createdAt;

    private static final GoblinMarketingZhengzaiRelationVo obj = new GoblinMarketingZhengzaiRelationVo();

    public static GoblinMarketingZhengzaiRelationVo getNew() {
        try {
            return (GoblinMarketingZhengzaiRelationVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinMarketingZhengzaiRelationVo();
        }
    }
}
