package com.liquidnet.common.third.zxlnft.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 检查地址是否属于同一个用户主体接口 GET请求方式
 * GET请求方式
 * @class: Nft054QueryUserAddressBelongToUser
 * @Package com.liquidnet.common.third.zxlnft.dto.nft
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/21 15:01
 */
@Data
public class Nft054QueryUserAddressBelongToUserReqDto implements Serializable {
    private static final long serialVersionUID = 5415600803546935859L;
    /**
     * 第一个地址
     */
    private String address1;
    /**
     * 第二个地址
     */
    private String address2;
    /**
     * 平台公钥
     */
    private String platformPubKey;
    /**
     * 平台签名信息：sign(address1+address2)
     */
    private String platformSignData;
    private static final Nft054QueryUserAddressBelongToUserReqDto obj = new Nft054QueryUserAddressBelongToUserReqDto();
    public static Nft054QueryUserAddressBelongToUserReqDto getNew() {
        try {
            return (Nft054QueryUserAddressBelongToUserReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Nft054QueryUserAddressBelongToUserReqDto();
        }
    }
}
