package com.liquidnet.service.sweet.utils;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.base.constant.RedisKeyExpireConst;
import com.liquidnet.service.sweet.constant.SweetConstant;
import com.liquidnet.service.sweet.entity.SweetAppletUsers;
import com.liquidnet.service.sweet.entity.SweetWechatUsers;
import com.liquidnet.service.sweet.mapper.SweetAppletUsersMapper;
import com.liquidnet.service.sweet.mapper.SweetWechatUsersMapper;
import com.liquidnet.service.sweet.vo.SweetAppletUsersVo;
import com.liquidnet.service.sweet.vo.SweetMaoDengVo;
import com.liquidnet.service.sweet.vo.SweetWechatUsersVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

@Component
@Slf4j
public class WechatUsersRedisUtils {

    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private SweetAppletUsersMapper sweetAppletUsersMapper;
    @Autowired
    private SweetWechatUsersMapper sweetWechatUsersMapper;

    public SweetWechatUsersVo getSweetWechatUsersOfUnionId(String unionId, Integer type) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_WECHAT_USERS_UNIONID.concat(unionId)
                .concat(SweetConstant.REDIS_KEY_SWEET_WECHAT_USERS_TYPE).concat(String.valueOf(type));
        Object obj = redisUtil.get(redisKey);
        if (null == obj) {
            // 从MySQL查询
            LambdaQueryWrapper<SweetWechatUsers> lambda = new QueryWrapper<SweetWechatUsers>()
                    .lambda()
                    .eq(SweetWechatUsers::getUnionId, unionId)
                    .eq(SweetWechatUsers::getType, type)
                    .orderByDesc(SweetWechatUsers::getUpdatedAt);
            List<SweetWechatUsers> sweetWechatUsers = sweetWechatUsersMapper.selectList(lambda);
            if (!CollectionUtils.isEmpty(sweetWechatUsers)) {
                SweetWechatUsersVo usersVo = SweetWechatUsersVo.getNew();
                BeanUtils.copyProperties(sweetWechatUsers.get(0), usersVo);
                setSweetWechatUsers(usersVo);
                return usersVo;
            } else {
                return null;
            }
        } else {
            SweetWechatUsersVo sweetWechatUsersVo = (SweetWechatUsersVo) obj;
            return sweetWechatUsersVo;
        }
    }

    public SweetWechatUsersVo getSweetWechatUsersOfOpenId(String openId, Integer type) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_WECHAT_USERS_OPENID.concat(openId)
                .concat(SweetConstant.REDIS_KEY_SWEET_WECHAT_USERS_TYPE).concat(String.valueOf(type));
        Object obj = redisUtil.get(redisKey);
        if (null == obj) {
            // 从MySQL查询
            LambdaQueryWrapper<SweetWechatUsers> lambda = new QueryWrapper<SweetWechatUsers>()
                    .lambda()
                    .eq(SweetWechatUsers::getOpenId, openId)
                    .eq(SweetWechatUsers::getType, type)
                    .orderByDesc(SweetWechatUsers::getUpdatedAt);
            List<SweetWechatUsers> sweetWechatUsers = sweetWechatUsersMapper.selectList(lambda);
            if (!CollectionUtils.isEmpty(sweetWechatUsers)) {
                SweetWechatUsersVo usersVo = SweetWechatUsersVo.getNew();
                BeanUtils.copyProperties(sweetWechatUsers.get(0), usersVo);
                setSweetWechatUsers(usersVo);
                return usersVo;
            } else {
                return null;
            }
        } else {
            SweetWechatUsersVo sweetWechatUsersVo = (SweetWechatUsersVo) obj;
            return sweetWechatUsersVo;
        }
    }

    public void setSweetWechatUsers(SweetWechatUsersVo sweetWechatUsersVo) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_WECHAT_USERS_UNIONID.concat(sweetWechatUsersVo.getUnionId())
                .concat(SweetConstant.REDIS_KEY_SWEET_WECHAT_USERS_TYPE).concat(String.valueOf(sweetWechatUsersVo.getType()));
        redisUtil.set(redisKey, sweetWechatUsersVo, RedisKeyExpireConst.SWEET_USER_SERVICE_UNIONID_EXPIRE);

        String redisKeyOpenId = SweetConstant.REDIS_KEY_SWEET_WECHAT_USERS_OPENID.concat(sweetWechatUsersVo.getOpenId())
                .concat(SweetConstant.REDIS_KEY_SWEET_WECHAT_USERS_TYPE).concat(String.valueOf(sweetWechatUsersVo.getType()));
        redisUtil.set(redisKeyOpenId, sweetWechatUsersVo, RedisKeyExpireConst.SWEET_USER_SERVICE_OPENID_EXPIRE);
    }

    public void delSweetWechatUsers(String unionId, String openId, Integer type) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_WECHAT_USERS_UNIONID.concat(unionId)
                .concat(SweetConstant.REDIS_KEY_SWEET_WECHAT_USERS_TYPE).concat(String.valueOf(type));
        redisUtil.del(redisKey);

        String redisKeyOpenId = SweetConstant.REDIS_KEY_SWEET_WECHAT_USERS_OPENID.concat(openId)
                .concat(SweetConstant.REDIS_KEY_SWEET_WECHAT_USERS_TYPE).concat(String.valueOf(type));
        redisUtil.del(redisKeyOpenId);
    }

    public SweetAppletUsersVo getSweetAppletUsersOfPhone(String mobile) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_APPLET_USERS_PHONE.concat(mobile);
        Object obj = redisUtil.get(redisKey);
        if (null == obj) {
            // 从MySQL数据库查询
            LambdaQueryWrapper<SweetAppletUsers> lambda = new QueryWrapper<SweetAppletUsers>()
                    .lambda()
                    .eq(SweetAppletUsers::getPhoneNumber, mobile)
                    .orderByDesc(SweetAppletUsers::getUpdatedAt);
            List<SweetAppletUsers> sweetAppletUsers = sweetAppletUsersMapper.selectList(lambda);
            if (!CollectionUtils.isEmpty(sweetAppletUsers)) {
                SweetAppletUsersVo usersVo = SweetAppletUsersVo.getNew();
                BeanUtils.copyProperties(sweetAppletUsers.get(0), usersVo);
                setSweetAppletUsers(usersVo);
                return usersVo;
            } else {
                return null;
            }
        } else {
            SweetAppletUsersVo sweetAppletUsersVo = (SweetAppletUsersVo) obj;
            return sweetAppletUsersVo;
        }
    }

    public SweetAppletUsersVo getSweetAppletUsersOfUnionId(String unionId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_APPLET_USERS_UNIONID.concat(unionId);
        Object obj = redisUtil.get(redisKey);
        if (null == obj) {
            // 从MySQL数据库查询
            LambdaQueryWrapper<SweetAppletUsers> lambda = new QueryWrapper<SweetAppletUsers>()
                    .lambda()
                    .eq(SweetAppletUsers::getUnionId, unionId)
                    .orderByDesc(SweetAppletUsers::getUpdatedAt);
            List<SweetAppletUsers> sweetAppletUsers = sweetAppletUsersMapper.selectList(lambda);
            if (!CollectionUtils.isEmpty(sweetAppletUsers)) {
                SweetAppletUsersVo usersVo = SweetAppletUsersVo.getNew();
                BeanUtils.copyProperties(sweetAppletUsers.get(0), usersVo);
                setSweetAppletUsers(usersVo);
                return usersVo;
            } else {
                return null;
            }
        } else {
            SweetAppletUsersVo sweetAppletUsersVo = (SweetAppletUsersVo) obj;
            return sweetAppletUsersVo;
        }
    }

    public void setSweetAppletUsers(SweetAppletUsersVo sweetAppletUsersVo) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_APPLET_USERS_PHONE.concat(sweetAppletUsersVo.getPurePhoneNumber());
        redisUtil.set(redisKey, sweetAppletUsersVo, RedisKeyExpireConst.SWEET_USER_APPLET_MOBILE_EXPIRE);

        String redisKeyU = SweetConstant.REDIS_KEY_SWEET_APPLET_USERS_UNIONID.concat(sweetAppletUsersVo.getUnionId());
        redisUtil.set(redisKeyU, sweetAppletUsersVo, RedisKeyExpireConst.SWEET_USER_APPLET_UNIONID_EXPIRE);
    }

    public void setStrawberryPosterClick(String openId, long time) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_STRAWBERRY_POSTER_CLICK.concat(openId);
        redisUtil.set(redisKey, 1, time);
    }

    public void delStrawberryPosterClick(String openId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_STRAWBERRY_POSTER_CLICK.concat(openId);
        redisUtil.del(redisKey);
    }

    public boolean getStrawberryPosterClick(String openId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_STRAWBERRY_POSTER_CLICK.concat(openId);
        Object obj = redisUtil.get(redisKey);
        if (null == obj) {
            return false;
        } else {
            return true;
        }
    }

 /*   public SweetMaoDengVo getSweetMaoDengText(String userId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_WECHAT_MAODENG_POSTER.concat(userId);
        Object obj = redisUtil.get(redisKey);
        if (null == obj) {
            return null;
        } else {
            SweetMaoDengVo sweetMaoDengVo = (SweetMaoDengVo) obj;

            return sweetMaoDengVo;
        }
    }*/

    public String getSweetMaoDengOpen(String fromUser) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_WECHAT_MAODENG_OPEN_POSTER.concat(fromUser);
        String obj = (String) redisUtil.get(redisKey);
        if (null == obj) {
            return null;
        } else {
            return obj;
        }
    }

    //整体取
    public SweetMaoDengVo getSweetMaoDeng(String userId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_WECHAT_MAODENG_POSTER.concat(":" + userId);
        SweetMaoDengVo obj = (SweetMaoDengVo) redisUtil.get(redisKey);
        if (null == obj) {
            return null;
        } else {
            return obj;
        }
    }

    //整体存
    public void setSweetMaoDeng(SweetMaoDengVo sweetMaoDengVo) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_WECHAT_MAODENG_POSTER.concat(":" + sweetMaoDengVo.getUserId());
        redisUtil.set(redisKey, sweetMaoDengVo);
    }

    //开启猫登天空活动
    public void setSweetMaoDengOpen(String fromUser, long time) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_WECHAT_MAODENG_OPEN_POSTER.concat(fromUser);
        redisUtil.set(redisKey, "1", time);
    }

    public void delSweetMaoDengOpen(String fromUser) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_WECHAT_MAODENG_OPEN_POSTER.concat(fromUser);
        redisUtil.del(redisKey);
    }

    //临时数据中转
    public void setSweetMaoDengTransfer(SweetMaoDengVo sweetMaoDengVo, long expire) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_WECHAT_MAODENG_POSTER_TRANSFER.concat(":" + sweetMaoDengVo.getUserId());
        redisUtil.set(redisKey, sweetMaoDengVo, expire);
    }

    //临时数据中转
    public SweetMaoDengVo getSweetMaoDengTransfer(String fromUser) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_WECHAT_MAODENG_POSTER_TRANSFER.concat(":" + fromUser);
        SweetMaoDengVo obj = (SweetMaoDengVo) redisUtil.get(redisKey);
        if (null == obj) {
            return null;
        } else {
            return obj;
        }
    }
}
