/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.toplink;

import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;

public class BufferManager {
    private static ConcurrentLinkedQueue<ByteBuffer> buffers = new ConcurrentLinkedQueue();
    private static boolean enableDirect;
    private static int maxBufferSize;

    public static void enableDirectBuffer(boolean enable) {
        enableDirect = enable;
    }

    public static void setBufferSize(int max) {
        maxBufferSize = max;
        buffers.clear();
    }

    public static ByteBuffer getBuffer() {
        ByteBuffer buffer = buffers.poll();
        return buffer == null ? BufferManager.allocate() : buffer;
    }

    public static void returnBuffer(ByteBuffer buffer) {
        buffer.clear();
        buffers.add(buffer);
    }

    private static ByteBuffer allocate() {
        return enableDirect ? ByteBuffer.allocateDirect(maxBufferSize) : ByteBuffer.allocate(maxBufferSize);
    }

    static {
        maxBufferSize = 4096;
    }
}

