package com.liquidnet.service.adam.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

@ApiModel(value = "AdamTagParentVo", description = "标签库")
public class AdamTagParentVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -7965840594354555093L;
    @ApiModelProperty(position = 11, value = "标签Key")
    private String val;
    @ApiModelProperty(position = 12, value = "标签名称")
    private String desc;
    @ApiModelProperty(position = 13, value = "子标签列表")
    private List<AdamTagParentVo> tagVos;

    private static final AdamTagParentVo obj = new AdamTagParentVo();

    public static AdamTagParentVo getNew() {
        try {
            return (AdamTagParentVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AdamTagParentVo();
        }
    }

    public String getVal() {
        return val;
    }

    public AdamTagParentVo setVal(String val) {
        this.val = val;
        return this;
    }

    public String getDesc() {
        return desc;
    }

    public AdamTagParentVo setDesc(String desc) {
        this.desc = desc;
        return this;
    }

    public List<AdamTagParentVo> getTagVos() {
        return tagVos;
    }

    public AdamTagParentVo setTagVos(List<AdamTagParentVo> tagVos) {
        this.tagVos = tagVos;
        return this;
    }
}
