package com.liquidnet.service.kylin.dto.vo.ignore;

import com.liquidnet.service.kylin.entity.KylinPerformanceRelations;
import com.liquidnet.service.kylin.entity.KylinPerformanceStatus;
import com.liquidnet.service.kylin.entity.KylinPerformances;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

@Data
public class PerformanceIgnoreVo {

    @ApiModelProperty(value = "主键")
    private String performancesId;
    @ApiModelProperty(value = "演出名称")
    private String title;
    @ApiModelProperty(value = "演出图片")
    private String imgPoster;
    @ApiModelProperty(value = "演出类型 1音乐节 2演唱会 3小型演出 4展览 6舞台剧 101音乐节 102小型演出(livehouse演出) 103巡演")
    private Integer type;
    @ApiModelProperty(value = "演出开始时间")
    private String timeStart;
    @ApiModelProperty(value = "演出结束时间")
    private String timeEnd;
    @ApiModelProperty(value = "停售时间")
    private String stopSellTime;
    @ApiModelProperty(value = "价格")
    private String price;
    @ApiModelProperty(value = "开售时间")
    private String sellTime;
    @ApiModelProperty(value = "城市id")
    private Integer cityId;
    @ApiModelProperty(value = "城市名称")
    private String cityName;
    @ApiModelProperty(value = "场地id")
    private String fieldId;
    @ApiModelProperty(value = "场地名称")
    private String fieldName;
    @ApiModelProperty(value = "经度")
    private String longitude;
    @ApiModelProperty(value = "纬度")
    private String latitude;
    @ApiModelProperty(value = "搭售id")
    private String projectId;
    @ApiModelProperty(value = "巡演id")
    private String roadShowId;

    // OSS
//    @ApiModelProperty(value = "演出详情")
//    private String details;
    // OSS
//    @ApiModelProperty(value = "购票须知")
//    private String noticeImage;

    @ApiModelProperty(value = "推荐顺序 0为不推荐")
    private Integer isRecommend;
    @ApiModelProperty(value = "状态")
    private Integer appStatus;
    @ApiModelProperty(value = "是否可买")
    private Integer statusSell;
    @ApiModelProperty(value = "是否关联会员")
    private Integer isMember;
    @ApiModelProperty(value = "是否开启缺票登记")
    private Integer isLackRegister;
    @ApiModelProperty(value = "是否实名")
    private Integer isTrueName;
    @ApiModelProperty(value = "限购张数")
    private Integer limitCount;
    @ApiModelProperty(value = "会员限购张数")
    private Integer limitCountMember;
    @ApiModelProperty(value = "是否专属")
    private Integer isExclusive;
    @ApiModelProperty(value = "是否优惠")
    private Integer isDiscount;
    @ApiModelProperty(value = "是否提前")
    private Integer isAdvance;
    @ApiModelProperty(value = "文案")
    private String message;

}
