package com.liquidnet.service.adam.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.liquidnet.service.adam.dto.AdamUserInfoDto;
import com.liquidnet.service.adam.entity.AdamUser;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * <p>
 * 用户 Mapper 接口
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-10
 */
@Repository
public interface AdamUserMapper extends BaseMapper<AdamUser> {

    int executeForDM(@Param("tn") String tn);

    @Select({"select u.mid," +
            "u.uid," +
            "u.mobile," +
            "u.passwd," +
            "u.state," +
            "u.is_complete as isComplete," +
            "u.created_at as createAt," +
            "u.updated_at as updatedAt," +
            "u.closed_at as closedAt," +
            "ui.nickname," +
            "ui.sex," +
            "ui.birthday," +
            "ui.area," +
            "ui.signature," +
            "ui.avatar," +
            "ui.background," +
            "ui.qr_code as qrCode," +
            "ui.tag_me as tagMe," +
            "ui.rong_cloud_token as rongCloudToken " +
            "from adam_user u,adam_user_info ui where u.uid = ui.uid " +
            "order by u.uid " +
            "limit #{rows},#{offset}"
    })
    List<AdamUserInfoDto> selectMultiForUserInfoDto(@Param("rows") int rows, @Param("offset") int offset);

    /**
     * 根据手机号获取 用户信息
     *
     * @param mobile
     * @return
     */
    AdamUserInfoDto selectByPhone(@Param("mobile") String mobile);

    /**
     * 根据手机号批量获取
     *
     * @param mobiles
     * @return
     */
    List<AdamUserInfoDto> selectByPhones(@Param("mobiles") String mobiles);
}
