package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: NFT转让结果查询
 * @class: GalaxyNftTransferQueryRespDto
 * @Package com.liquidnet.service.galaxy.dto.param;
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/8/4 18:51
 */
@ApiModel(value = "GalaxyNftTransferQueryRespDto", description = "NFT转让结果查询")
@Data
public class GalaxyNftTransferQueryRespDto implements Serializable,Cloneable {
    @ApiModelProperty(position = 1, required = true, value = "nft唯一id")
    private String nftId;

    @ApiModelProperty(position = 1, required = true, value = "拥有者用户ID")
    private String ownerUserId;

    @ApiModelProperty(position = 1, required = true, value = "拥有者地址")
    private String ownerAddress;

    @ApiModelProperty(position = 1, required = true, value = "转出者用户ID")
    private String fromUserId;

    @ApiModelProperty(position = 1, required = true, value = "转出者地址")
    private String fromAddress;

    @ApiModelProperty(position = 1, required = true, value = "转让时间")
    private String transferTime;

    @ApiModelProperty(position = 3, required = true, value = "路由类型")
    private String routerType;

    @ApiModelProperty(position = 4, required = true, value = "转让hash")
    private String transferHash;

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyNftTransferQueryRespDto obj = new GalaxyNftTransferQueryRespDto();

    public static GalaxyNftTransferQueryRespDto getNew() {
        try {
            return (GalaxyNftTransferQueryRespDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyNftTransferQueryRespDto();
        }
    }
}
