package com.liquidnet.client.admin;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.web.context.request.RequestContextListener;

/**
 * 启动程序
 *
 * @author LiquidNet
 */
@EnableFeignClients(basePackages = {"com.liquidnet"})
@SpringBootApplication(exclude = { DataSourceAutoConfiguration.class, RedisAutoConfiguration.class}, scanBasePackages = {"com.liquidnet"})
public class ClientAdminApplication
{
    public static void main(String[] args)
    {
        // System.setProperty("spring.devtools.restart.enabled", "false");
        SpringApplication.run(ClientAdminApplication.class, args);
        System.out.println("(♥◠‿◠)ﾉﾞ  LiquidNet-admin启动成功   ლ(´ڡ`ლ)ﾞ  \n");
    }

    @Bean
    public RequestContextListener requestContextListener(){
        return new RequestContextListener();
    }
}
