package com.liquidnet.client.admin.web.controller.adam.company;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.page.PageDomain;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.core.page.TableSupport;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.dto.query.AdamComInfoQuery;
import com.liquidnet.service.adam.entity.AdamComInfo;
import com.liquidnet.service.feign.adam.admin.company.FeignAdminAdamComInfoClient;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Api(tags = "Adam com info")
@Controller
@RequestMapping("/adam/com-info")
public class AdamComInfoController extends BaseController {
    /** slf4j logger */
    private static final Logger log = LoggerFactory.getLogger(AdamComInfoController.class);

    @Autowired
    private FeignAdminAdamComInfoClient feignAdminAdamComInfoClient;

    @ApiOperation(value = "获取公司信息分页列表")
    @GetMapping("/queryList")
    public TableDataInfo queryList() {

        TableDataInfo rspData = new TableDataInfo();

        PageDomain pageDomain = TableSupport.buildPageRequest();

        AdamComInfoQuery query = new AdamComInfoQuery();
        ResponseDto<Page<AdamComInfo>> pageResponseDto = feignAdminAdamComInfoClient.queryList(query, pageDomain.getPageNum(), pageDomain.getPageSize());
        Page<AdamComInfo> dataList = pageResponseDto.getData();
        if (null == pageDomain.getPageNum() || null == pageDomain.getPageSize()) {
            rspData.setRows(dataList.getRecords());
            rspData.setTotal(dataList.getTotal());
            return rspData;
        }

        log.info(JSON.toJSONString(pageResponseDto));
        return rspData;
    }

}
