package com.liquidnet.service.feign.adam.admin.transaction;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.dto.AdamTransactionDto;
import com.liquidnet.service.adam.dto.admin.transaction.AdamConversionRecordReq;
import com.liquidnet.service.adam.dto.admin.transaction.AdamPayoutDetailDto;
import com.liquidnet.service.adam.dto.admin.transaction.AdamPayoutRecordReq;
import com.liquidnet.service.adam.dto.admin.transaction.AdamRechargeRecordReq;
import com.liquidnet.service.feign.adam.constant.FeignAdamConstant;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.*;

@Service
@FeignClient(name = FeignAdamConstant.LIQUIDNET_SERVICE_ADAM,
        path = FeignAdamConstant.CONTEXT_PATH,
        fallback = FallbackFactory.Default.class,
        contextId = FeignAdamConstant.CONTEXT_ADMIN_TRANSACTION)
public interface FeignTransactionQueryClient {

    @PostMapping(value = "/admin/adam-trans-query/rechargeList")
    ResponseDto<Page<AdamTransactionDto>> rechargeList(@RequestBody AdamRechargeRecordReq adamRechargeRecordReq,
                                                       @RequestParam("pageNum") int pageNum,
                                                       @RequestParam("pageSize") int pageSize);

    @PostMapping(value = "/admin/adam-trans-query/payoutList")
    ResponseDto<Page<AdamTransactionDto>> payoutList(@RequestBody AdamPayoutRecordReq adamPayoutRecordReq,
                                                     @RequestParam("pageNum") int pageNum,
                                                     @RequestParam("pageSize") int pageSize);

    @PostMapping(value = "/admin/adam-trans-query/conversionList")
    ResponseDto<Page<AdamTransactionDto>> conversionList(@RequestBody AdamConversionRecordReq adamConversionRecordReq,
                                                         @RequestParam("pageNum") int pageNum,
                                                         @RequestParam("pageSize") int pageSize);

    @PostMapping(value = "/admin/adam-trans-query/getPayoutDetailByOrderId")
    ResponseDto<AdamPayoutDetailDto> getPayoutDetailByOrderId(@RequestParam("orderId") String orderId);

}
