package com.liquidnet.service.feign.adam.api.account;

import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.bank.currencycloud.entity.BankCcBalance;
import com.liquidnet.service.feign.adam.constant.FeignAdamConstant;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Service
@FeignClient(name = FeignAdamConstant.LIQUIDNET_SERVICE_ADAM,
        path = FeignAdamConstant.CONTEXT_PATH,
        fallback = FallbackFactory.Default.class,
        contextId = FeignAdamConstant.CONTEXT_API_ACCOUNT_WALLET
       )
public interface FeignAdamAccountWalletClient {

    @RequestMapping(value =  "/feign/adam-account-wallet/push_notify_bank_cc_balance", method = RequestMethod.POST)
    ResponseDto pushNotifyBalance(@RequestBody BankCcBalance balance);

}
