package com.liquidnet.service.adam.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.dto.AdamEntersParam;
import com.liquidnet.service.adam.dto.vo.AdamEntersVo;
import com.liquidnet.service.adam.entity.AdamEnters;
import com.liquidnet.service.adam.service.IAdamEntersService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 入场人 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-04-28
 */
@Api(tags = "入场人")
@Slf4j
@RestController
@RequestMapping("/enters")
public class AdamEntersController  {
    @Autowired
    IAdamEntersService adamEntersService;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "入场人列表")
    @PostMapping("list")
    public ResponseDto<List<AdamEntersVo>> list() {
        // TODO: 2021/4/29 获取登录UID
        String uid = "1";


        List<AdamEntersVo> voList = new ArrayList<>();
        adamEntersService.list(uid).forEach(i -> {
            voList.add(AdamEntersVo.getNew().copy(i));
        });

        return ResponseDto.success(voList);
    }

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "添加入场人")
    @PostMapping("add")
    public ResponseDto<Object> add(@RequestBody AdamEntersParam parameter) {
        // TODO: 2021/4/28 数据校验、身份认证、获取登录UID
        String uid = "1";


        AdamEnters addInfo = new AdamEnters();
        BeanUtils.copyProperties(parameter, addInfo);
        addInfo.setUid(uid);
        addInfo.setEntersId(String.valueOf(IDGenerator.nextSnowId()));
        addInfo.setCreatedAt(LocalDateTime.now());
        addInfo.setState(1);

        adamEntersService.add(addInfo);

        return ResponseDto.success();
    }

    @ApiOperationSupport(order = 3)
    @ApiOperation(value = "入场人详情")
    @PostMapping("query/{id}")
    public ResponseDto<AdamEntersVo> query(@PathVariable(name = "id") String entersId) {
        // TODO: 2021/4/28 校验、获取登录UID
        String uid = "1";

        AdamEnters info = adamEntersService.query(uid, entersId);

        return ResponseDto.success(AdamEntersVo.getNew().copy(info));
    }

    @ApiOperationSupport(order = 4)
    @ApiOperation(value = "入场人编辑")
    @PostMapping("edit")
    public ResponseDto<Object> edit(@RequestBody AdamEntersParam parameter) {
        // TODO: 2021/4/28 校验、获取登录UID
        String uid = "1";

        AdamEnters updateInfo = new AdamEnters();
        BeanUtils.copyProperties(parameter, updateInfo);
        updateInfo.setUpdatedAt(LocalDateTime.now());
        updateInfo.setUid(uid);
        updateInfo.setState(1);

        adamEntersService.edit(updateInfo);

        return ResponseDto.success();
    }

    @ApiOperationSupport(order = 5)
    @ApiOperation(value = "入场人删除")
    @PostMapping("del/{id}")
    public ResponseDto<Object> del(@PathVariable(name = "id") String entersId) {
        // TODO: 2021/4/28 校验、获取登录UID
        String uid = "1";

        adamEntersService.remove(uid, entersId);

        return ResponseDto.success();
    }
}
