package com.liquidnet.service.executor.main.handler;

import com.alibaba.fastjson.JSON;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.feign.adam.task.FeignTaskAdamPayoutClient;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import com.xxl.job.core.log.XxlJobLogger;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class ExecutorAdamPayoutHandler {

    @Autowired
    private FeignTaskAdamPayoutClient feignAdamPayoutTaskClient;

    @XxlJob(value = "sev-adam:payoutExecutionDateTask")
    public ReturnT<String> payoutExecutionDateTask(String param) {
        XxlJobLogger.log("start:adam.payout.executionDateTask");
        ResponseDto responseDto = feignAdamPayoutTaskClient.executionDateTask();
        XxlJobLogger.log("end:adam.payout.executionDateTask:[{}]", JSON.toJSONString(responseDto));
        return ReturnT.SUCCESS;
    }



    @XxlJob(value = "sev-adam:awaitingFundsDoPayoutTask")
    public ReturnT<String> awaitingFundsDoPayoutTask(String param) {
        XxlJobLogger.log("start:adam.payout.awaitingFundsDoPayoutTask");
        ResponseDto responseDto = feignAdamPayoutTaskClient.awaitingFundsDoPayoutTask();
        XxlJobLogger.log("end:adam.payout.awaitingFundsDoPayoutTask:[{}]", JSON.toJSONString(responseDto));
        return ReturnT.SUCCESS;
    }

}
