package com.liquidnet.service.kylin.dto.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 * 轮播图 banner 搜索 需要的参数
 * </p>
 * @author jiangxiulong
 * @since 2021-05-03 11:19 上午
 */

@Data
public class BannersSearchParam implements Serializable {
    @ApiModelProperty(value = "标题", example = "这是一个banner标题")
    private String name;

    @ApiModelProperty(value = "跳转类型 6演出跳转 7商品跳转 8巡演跳转 12展示分享按钮的web连接 14积分商品详情 100活动跳转 999不跳转 998个人信息跳转", example = "6")
    private Integer type;

    @ApiModelProperty(value = "是否显示 0-否,1-是", example = "1", allowableValues = "0,1")
    private Integer isShow;

    @ApiModelProperty(value = "展示位置", example = "1")
    private Integer position;

    @ApiModelProperty(value = "页数 ", example = "1")
    private int page;

    @ApiModelProperty(value = "数量 ", example = "10")
    private int size;
}
