package com.liquidnet.service.kylin.dto.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;


/**
 * 修改场地全部显示数据参数
 */
@Data
public class TicketVo implements Serializable {
    @ApiModelProperty(value = "主键")
    private String ticketsId;

    @ApiModelProperty(value = "票种名称", example = "测试票")
    private String title;

    @ApiModelProperty(value = "是否学生票 0否 1是", example = "0", hidden = true)
    private int isStudent;

    @ApiModelProperty(value = "是否电子票", example = "0")
    private int isElectronic;

    @ApiModelProperty(value = "是否快递票", example = "0")
    private int isExpress;

    @ApiModelProperty(value = "类型", example = "2")
    private int types;

    @ApiModelProperty(value = "价格", example = "100.00")
    private BigDecimal price;

    @ApiModelProperty(value = "快递票截止日期", example = "2020-12-01T12:00:00")
    private String timeEndExpress;

    @ApiModelProperty(value = "总库存", example = "100")
    private int totalGeneral;

    @ApiModelProperty(value = "总兑换库存", example = "100")
    private int totalExchange;

    @ApiModelProperty(value = "限购数量", example = "0")
    private int limitCount;

    @ApiModelProperty(value = "票种开售时间", example = "2020-12-01T12:00:00")
    private String timeStart;

    @ApiModelProperty(value = "票种结售时间", example = "2020-12-01T14:00:00")
    private String timeEnd;

    @ApiModelProperty(value = "票种说明", example = "这是票种说明")
    private String describes;

    @ApiModelProperty(value = "票状态 -1删除;0未提交;1审核中;2审核中（自动在售）;3审核通过;4审核未通过;6在售;7停售;8售罄;9未开始;10已结束", example = "0")
    private int status;

    @ApiModelProperty(value = "是否展示二维码 0否 1是", example = "0")
    private int isShowCode;

    @ApiModelProperty(value = "二维码显示时间", example = "2020-12-01T14:00:00")
    private String qrCodeShowTime;

    @ApiModelProperty(value = "场次id")
    private String timesId;

    @ApiModelProperty(value = "")
    private String createdAt;

    @ApiModelProperty(value = "")
    private String updatedAt;
}