package com.liquidnet.service.kylin.controller.admin;

import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.kylin.dao.FieldMisDetailsDao;
import com.liquidnet.service.kylin.dao.FieldMisListDao;
import com.liquidnet.service.kylin.dto.param.FieldsAuditParam;
import com.liquidnet.service.kylin.dto.param.FieldsParam;
import com.liquidnet.service.kylin.dto.param.FieldsSearchParam;
import com.liquidnet.service.kylin.dto.param.FieldsStatusParam;
import com.liquidnet.service.kylin.dto.vo.FieldsVo;
import com.liquidnet.service.kylin.dto.vo.PagerVo;
import com.liquidnet.service.kylin.service.impl.admin.FieldsAdminServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;

@Api
@RestController
@RequestMapping("/admin/fields")
public class FieldsAdminController {

    @Autowired
    private FieldsAdminServiceImpl fieldsAdminService;

    @PostMapping(value = "")
    @ApiOperation(value = "创建场地")
    @ApiResponse(response = FieldsVo.class, code = 200, message = "接口返回对象参数")
    public ResponseDto<FieldsVo> createFields(@RequestBody FieldsParam fieldsParam) {
        boolean result = fieldsAdminService.fieldCreate(fieldsParam);
        if (result) {
            return ResponseDto.success();
        } else {
            return ResponseDto.failure("场地创建失败");
        }
    }

    @PutMapping(value = "")
    @ApiOperation(value = "mis修改场地全部数据")
    @ApiResponse(response = FieldsVo.class, code = 200, message = "接口返回对象参数")
    public ResponseDto<FieldsVo> fieldUpdate(@RequestBody FieldsParam fieldsParam) {
        boolean result = fieldsAdminService.fieldUpdateMessage(fieldsParam);
        if (result) {
            return ResponseDto.success();
        } else {
            return ResponseDto.failure("修改场地失败");
        }
    }

    @PostMapping(value = "list")
    @ApiOperation(value = "mis获取场地列表")
    @ApiResponse(response = PagerVo.class, code = 200, message = "接口返回对象参数")
    public ResponseDto<PagerVo<FieldMisListDao>> fieldList(@RequestBody FieldsSearchParam fieldsSearchParam) {
        List<FieldMisListDao> result = fieldsAdminService.fieldList(fieldsSearchParam);
        Long total = fieldsAdminService.fieldListCount(fieldsSearchParam);

        PagerVo<FieldMisListDao> pagerVo = new PagerVo();
        pagerVo.setRows(result);
        pagerVo.setTotal(total);

        if (pagerVo.getRows().size() > 0) {
            return ResponseDto.success(pagerVo);
        } else {
            return ResponseDto.failure("获取列表失败");
        }
    }

    @GetMapping(value = "details")
    @ApiOperation(value = "mis场地详情")
    @ApiResponse(response = FieldMisDetailsDao.class, code = 200, message = "接口返回对象参数")
    public ResponseDto<FieldMisDetailsDao> fieldDetails(@RequestParam("fieldsId") String fieldsId) {
        FieldMisDetailsDao result = null;
        result = fieldsAdminService.fieldDetails(fieldsId);
        if (null != result) {
            return ResponseDto.success(result);
        } else {
            return ResponseDto.failure("获取场地详情失败");
        }
    }

    @PostMapping(value = "audit")
    @ApiOperation(value = "mis场地审核")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> fieldAudit(@RequestBody FieldsAuditParam fieldsAuditParam) {

        boolean result = fieldsAdminService.fieldAudit(fieldsAuditParam);

        if (result) {
            return ResponseDto.success("审核成功");
        } else {
            return ResponseDto.failure("审核失败");
        }
    }

    @PostMapping(value = "status")
    @ApiOperation(value = "mis修改场地状态")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> fieldStatus(@RequestBody FieldsStatusParam fieldsStatusParam) {
        boolean result = fieldsAdminService.fieldStatus(fieldsStatusParam);
        if (result) {
            return ResponseDto.success("修改成功");
        } else {
            return ResponseDto.failure("获取列表失败");
        }
    }
}
