package com.liquidnet.service.platform.controller.ticketSystem;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.platform.param.ticketSystem.*;
import com.liquidnet.service.platform.service.ticketSystem.ITicketSystemService;
import com.liquidnet.service.platform.vo.ticketSystem.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import lombok.extern.slf4j.XSlf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;
import java.util.List;

@Api(tags = "票务平台")
@RestController
@RequestMapping("st")
@Slf4j
public class TicketSystemController {

    @Autowired
    ITicketSystemService ticketSystemService;

    @GetMapping("type/list")
    @ApiOperation("查询标准演出类型")
    public ResponseDto<List<STPTListVo>> getPerformanceTypeList() {
        try {
            String accessToken = ticketSystemService.getAccessToken();
            List<STPTListVo> vo = ticketSystemService.getPerformanceTypeList(accessToken);
            return ResponseDto.success(vo);
        } catch (Exception e) {
            log.error("查询标准演出类型 ERROR : {}", e);
            return ResponseDto.failure();
        }
    }

    @GetMapping("field/list")
    @ApiOperation("查询标准演出场所")
    public ResponseDto<List<STFieldListVo>> getFieldList(STFieldListParam fieldListParam) {
        try {
            String accessToken = ticketSystemService.getAccessToken();
            List<STFieldListVo> vo = ticketSystemService.getFieldList(accessToken, fieldListParam);
            return ResponseDto.success(vo);
        } catch (Exception e) {
            log.error("查询标准演出场所 ERROR : {}", e);
            return ResponseDto.failure();
        }
    }

    @PostMapping("field/insert")
    @ApiOperation("新增演出场厅")
    public ResponseDto<STFieldChangeVo> insertField(STInsertFieldParam insertFieldParam) {
        try {
            String accessToken = ticketSystemService.getAccessToken();
            STFieldChangeVo vo = ticketSystemService.insertField(accessToken, insertFieldParam);
            return ResponseDto.success(vo);
        } catch (Exception e) {
            log.error("新增演出场厅 ERROR : {}", e);
            return ResponseDto.failure();
        }
    }


    @PostMapping("performance/insert")
    @ApiOperation("上报演出场次")
    public ResponseDto<String> insertPerformance(STInsertPerformanceParam insertPerformanceParam) {
        try {
            String accessToken = ticketSystemService.getAccessToken();
            String vo = ticketSystemService.insertPerformance(accessToken, insertPerformanceParam);
            return ResponseDto.success(vo);
        } catch (Exception e) {
            log.error("上报演出场次 ERROR : {}", e);
            return ResponseDto.failure();
        }
    }

    @PostMapping("performance/update")
    @ApiOperation("更新上报的演出项目数据")
    public ResponseDto<Boolean> updatePerformance(STUpdatePerformanceParam updatePerformanceParam) {
        try {
            String accessToken = ticketSystemService.getAccessToken();
            boolean vo = ticketSystemService.updatePerformance(accessToken, updatePerformanceParam);
            return ResponseDto.success(vo);
        } catch (Exception e) {
            log.error("更新上报的演出项目数据 ERROR : {}", e);
            return ResponseDto.failure();
        }
    }

    @PostMapping("times/update")
    @ApiOperation("更新上报的场次数据")
    public ResponseDto<Boolean> updateTimes(STUpdateTimesParam updateTimesParam) {
        try {
            String accessToken = ticketSystemService.getAccessToken();
            boolean vo = ticketSystemService.updateTimes(accessToken, updateTimesParam);
            return ResponseDto.success(vo);
        } catch (Exception e) {
            log.error("更新上报的场次数据 ERROR : {}", e);
            return ResponseDto.failure();
        }
    }

    @PostMapping("ticketPrice/insert")
    @ApiOperation("上报票价信息")
    public ResponseDto<Boolean> insertTicketPrice(STInsertTicketPriceParam insertTicketPriceParam) {
        try {
            String accessToken = ticketSystemService.getAccessToken();
            boolean vo = ticketSystemService.insertTicketPrice(accessToken, insertTicketPriceParam);
            return ResponseDto.success(vo);
        } catch (Exception e) {
            log.error("上报票价信息 ERROR : {}", e);
            return ResponseDto.failure();
        }
    }

    @PostMapping("ticketPrice/del")
    @ApiOperation("删除票价信息")
    public ResponseDto<Boolean> delTicketPrice(STDelTicketPriceParam delTicketPriceParam) {
        try {
            String accessToken = ticketSystemService.getAccessToken();
            boolean vo = ticketSystemService.delTicketPrice(accessToken, delTicketPriceParam);
            return ResponseDto.success(vo);
        } catch (Exception e) {
            log.error("新增演出场厅 ERROR : {}", e);
            return ResponseDto.failure();
        }
    }

    @PostMapping("ticket/insert")
    @ApiOperation("上报票信息")
    public ResponseDto<Boolean> insertTicket(STInsertTicketParam insertTicketParam) {
        try {
            String accessToken = ticketSystemService.getAccessToken();
            boolean vo = ticketSystemService.insertTicket(accessToken, insertTicketParam);
            return ResponseDto.success(vo);
        } catch (Exception e) {
            log.error("上报票信息 ERROR : {}", e);
            return ResponseDto.failure();
        }
    }

    @PostMapping("ticket/del")
    @ApiOperation("删除票信息")
    public ResponseDto<Boolean> delTicket(STDelTicketParam delTicketParam) {
        try {
            String accessToken = ticketSystemService.getAccessToken();
            boolean vo = ticketSystemService.delTicket(accessToken, delTicketParam);
            return ResponseDto.success(vo);
        } catch (Exception e) {
            log.error("删除票信息 ERROR : {}", e);
            return ResponseDto.failure();
        }
    }


    @PostMapping("order/insert")
    @ApiOperation("上报订单信息")
    public ResponseDto<Boolean> insertOrder(STInsertOrderParam insertOrderParam) {
        try {
            String accessToken = ticketSystemService.getAccessToken();
            boolean vo = ticketSystemService.insertOrder(accessToken, insertOrderParam);
            return ResponseDto.success(vo);
        } catch (Exception e) {
            log.error("上报订单信息 ERROR : {}", e);
            return ResponseDto.failure();
        }
    }

    @PostMapping("order/refund")
    @ApiOperation("上报退票信息")
    public ResponseDto<Boolean> refundOrder(STRefundOrderParam refundOrderParam) {
        try {
            String accessToken = ticketSystemService.getAccessToken();
            Boolean vo = ticketSystemService.refundOrder(accessToken, refundOrderParam);
            return ResponseDto.success(vo);
        } catch (Exception e) {
            log.error("上报退票信息 ERROR : {}", e);
            return ResponseDto.failure();
        }
    }

    @PostMapping("check/insert")
    @ApiOperation("上报检票数据")
    public ResponseDto<Boolean> insertCheck(List<CheckVo> ticketList) {
        try {
            String accessToken = ticketSystemService.getAccessToken();
            boolean vo = ticketSystemService.insertCheck(accessToken, ticketList);
            return ResponseDto.success(vo);
        } catch (Exception e) {
            log.error("上报检票数据 ERROR : {}", e);
            return ResponseDto.failure();
        }
    }

}
