package com.liquidnet.client.admin.zhengzai.goblin.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.zhengzai.goblin.service.IGoblinFrontCompilationsService;
import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.goblin.constant.GoblinRedisConst;
import com.liquidnet.service.goblin.entity.GoblinFrontCompilations;
import com.liquidnet.service.goblin.mapper.GoblinFrontCompilationsMapper;
import com.liquidnet.service.goblin.param.GoblinFrontCompilationsParam;
import com.mongodb.BasicDBObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 合集 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2022-01-06
 */
@Service
public class GoblinFrontCompilationsServiceImpl extends ServiceImpl<GoblinFrontCompilationsMapper, GoblinFrontCompilations> implements IGoblinFrontCompilationsService {
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    GoblinFrontCompilationsMapper goblinFrontCompilationsMapper;
    @Autowired
    private RedisDataSourceUtil redisDataSourceUtil;


    public boolean create(GoblinFrontCompilations goblinFrontCompilations){
        goblinFrontCompilations.setCreateTime(LocalDateTime.now());
        //设置bannerid
        goblinFrontCompilations.setCompilationsId(IDGenerator.nextSnowId());
        goblinFrontCompilationsMapper.insert(goblinFrontCompilations);
        return true;
    }
    public boolean update(GoblinFrontCompilations goblinFrontCompilations){
        goblinFrontCompilations.setUpdateTime(LocalDateTime.now());
        //数据库修改
        goblinFrontCompilationsMapper.updateById(goblinFrontCompilations);
        return true;
    }
    public GoblinFrontCompilations getOne(Long id){
        return  goblinFrontCompilationsMapper.selectById(id);
    }

    public List<GoblinFrontCompilations> getListGoblinFrontCompilations(String name){
        LambdaQueryWrapper<GoblinFrontCompilations> queryWrapper = Wrappers.lambdaQuery(GoblinFrontCompilations.class);
        queryWrapper.ne(GoblinFrontCompilations::getDelTag,"1");
        if(StringUtil.isNotBlank(name)){
            queryWrapper.like(GoblinFrontCompilations::getName,name);
        }
        List<GoblinFrontCompilations> list= goblinFrontCompilationsMapper.selectList(queryWrapper);
        return list;
    }
    public boolean delte(Long id){
        GoblinFrontCompilations goblinFrontCompilations=goblinFrontCompilationsMapper.selectById(id);
        goblinFrontCompilations.setDelTag(1);
        this.update(goblinFrontCompilations);
        return true;
    }
    public PageInfo<GoblinFrontCompilationsParam> page(int pageSize, int pageNumber) {
        PageInfo<GoblinFrontCompilationsParam> pageInfoTmp = null;
        try {
            PageHelper.startPage(pageNumber, pageSize);
            LambdaQueryWrapper<GoblinFrontCompilations> queryWrapper = Wrappers.lambdaQuery(GoblinFrontCompilations.class);
            queryWrapper.orderByDesc(GoblinFrontCompilations::getCreateTime);
            List<GoblinFrontCompilations> list=goblinFrontCompilationsMapper.selectList(queryWrapper);
            List<GoblinFrontCompilationsParam> list1=new ArrayList<>();
            for(GoblinFrontCompilations goblinFrontCompilations:list){
                GoblinFrontCompilationsParam goblinFrontCompilationsParam=new GoblinFrontCompilationsParam();
                BeanUtils.copyProperties(goblinFrontCompilations,goblinFrontCompilationsParam);
                list1.add(goblinFrontCompilationsParam);
            }

            pageInfoTmp = new PageInfo(list1);
        } catch (Exception e) {
            return new PageInfo();
        }
        return pageInfoTmp;
    }
    public boolean online(){
        //mysql 获取list
        LambdaQueryWrapper<GoblinFrontCompilations> queryWrapper = Wrappers.lambdaQuery(GoblinFrontCompilations.class);
        queryWrapper.orderByDesc(GoblinFrontCompilations::getCreateTime);
        List<GoblinFrontCompilations> list=goblinFrontCompilationsMapper.selectList(queryWrapper);
        // mongodb
        for(GoblinFrontCompilations goblinFrontCompilations:list){
            GoblinFrontCompilations goblinFrontCompilations1= mongoTemplate.findOne(Query.query(Criteria.where("compilationsId").is(goblinFrontCompilations.getCompilationsId())), GoblinFrontCompilations.class, GoblinFrontCompilations.class.getSimpleName());
            if(null==goblinFrontCompilations1){
                mongoTemplate.save(goblinFrontCompilations,GoblinFrontCompilations.class.getSimpleName());
            }else{
                BasicDBObject orderObject = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(goblinFrontCompilations1)));
                mongoTemplate.getCollection(GoblinFrontCompilations.class.getSimpleName()).updateOne(
                        Query.query(Criteria.where("compilationsId").is(goblinFrontCompilations.getCompilationsId())).getQueryObject(),
                        orderObject
                );
            }
        }
        for(GoblinFrontCompilations goblinFrontCompilations:list){
            redisDataSourceUtil.getRedisGoblinUtil().set(GoblinRedisConst.COMPLIATIONS+goblinFrontCompilations.getMid(),goblinFrontCompilations);
        }
        return true;
    }
}
