package com.liquidnet.service.bank.currencycloud.service;

import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.bank.currencycloud.dto.BankCcConversionDatesDto;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author LiChen
 * @date 2020/10/12 2:46 下午
 */
public interface IBankCcReferenceService {

    /**
     * Find out what information is required to make payments to beneficiaries in specified currencies and countries.
     *
     * @param currency           Currency in which money is held in the beneficiary's bank account. Three-letter currency code in uppercase.
     * @param bankAccountCountry Two-letter country code.
     * @param beneficiaryCountry Two-letter country code. If the beneficiary is a company, the country in which the company is registered. If the beneficiary is an individual, a country in which the beneficiary holds nationality.
     */
    ResponseDto<List<Map<String, String>>> getBeneficiaryRequirements(String currency, String bankAccountCountry, String beneficiaryCountry);


    ResponseDto<BankCcConversionDatesDto> getConversionDates(String conversionPair, Date startDate);

}
