package com.liquidnet.client.admin.web.controller.zhengzai.kylin;

import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.zhengzai.kylin.service.impl.KylinPerformancesAdminServiceImpl;
import com.liquidnet.service.kylin.dao.PerformanceSimpleAllDao;
import com.liquidnet.service.kylin.dao.PerformanceTitleDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

@Controller
@RequestMapping("/kylin/base")
public class KylinBaseController extends BaseController {

    @Autowired
    private KylinPerformancesAdminServiceImpl kylinPerformancesService;


    @GetMapping(value = "/performance/status")
    @ResponseBody
    public AjaxResult listByStatus(@RequestParam(value = "status") String status, @RequestParam(value = "title",required = false) String title) {
        try {
            List<PerformanceSimpleAllDao> result = kylinPerformancesService.getListDetailByStatus(status, title);
            AjaxResult ajax = new AjaxResult();
            ajax.put("value", result);
            return ajax;
        }catch (Exception e){
            return AjaxResult.error("演出不存在");
        }
    }

}
