package com.liquidnet.service.goblin.service.impl;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.goblin.dto.GoblinUserSafeConfigDto;
import com.liquidnet.service.goblin.service.IGoblinUserSafeConfigService;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import com.liquidnet.service.goblin.util.QueueUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.LinkedList;

@Service
public class GoblinUserSafeConfigServiceImpl implements IGoblinUserSafeConfigService {
    @Autowired
    private QueueUtils queueUtils;
    @Autowired
    private GoblinRedisUtils goblinRedisUtils;

    @Override
    public boolean initSafePasswd(String passwd, String uid) {
        GoblinUserSafeConfigDto userSafeConfigDto = GoblinUserSafeConfigDto.getNew();
        userSafeConfigDto.setPasswd(passwd);
        if (goblinRedisUtils.setUserSafeConfigDto(uid, userSafeConfigDto)) {
            LinkedList<String> toMqSqls = CollectionUtil.linkedListString();
            toMqSqls.add(SqlMapping.get("goblin_user_safe_config.add_passwd"));
            LinkedList<Object[]> initUserSafeConfigObjs = CollectionUtil.linkedListObjectArr();
            initUserSafeConfigObjs.add(new Object[]{uid, passwd, LocalDateTime.now()});
            queueUtils.sendMsgByRedis(MQConst.GoblinQueue.SQL_GOODS.getKey(), SqlMapping.gets(toMqSqls, initUserSafeConfigObjs));
            return true;
        }
        return false;
    }
}
