package com.liquidnet.service.galaxy.router.xuper.service;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.constant.GalaxyEnum;
import com.liquidnet.service.galaxy.dto.param.*;
import com.liquidnet.service.galaxy.router.strategy.IGalaxyRouterStrategyTradeQuery;
import com.liquidnet.service.galaxy.router.strategy.annotation.StrategyGalaxyRouterTradeQueryHandler;
import com.liquidnet.service.galaxy.router.xuper.biz.XuperTradeQueryBiz;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyRouterStrategyXuperTradeQueryImpl
 * @Package com.liquidnet.service.galaxy.router.xuper.service
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/6/27 11:04
 */
@Slf4j
@Component
@StrategyGalaxyRouterTradeQueryHandler(GalaxyEnum.RouterTypeEnum.XUPER)
public class GalaxyRouterStrategyXuperTradeQueryImpl implements IGalaxyRouterStrategyTradeQuery {
    @Autowired
    private XuperTradeQueryBiz xuperTradeQueryBiz;

    @Override
    public ResponseDto<GalaxyQueryNftInfoRespDto> queryNftInfo(GalaxyQueryNftInfoReqDto reqDto) {
        return xuperTradeQueryBiz.queryNftInfo(reqDto);
    }

    @Override
    public ResponseDto<GalaxyQueryNftInfoRespDto> queryTransNftInfo(GalaxyQueryNftInfoReqDto reqDto) {
        return xuperTradeQueryBiz.queryTransNftInfo(reqDto);
    }

    @Override
    public ResponseDto<GalaxyQueryNftTradeListRespDto> queryNftTradeList(GalaxyQueryNftTradeListReqDto reqDto) {
        return xuperTradeQueryBiz.queryNftTradeList(reqDto);
    }

    @Override
    public ResponseDto<GalaxyQuerySeriesInfoRespDto> querySeriesInfo(GalaxyQuerySeriesInfoReqDto reqDto) {
        return xuperTradeQueryBiz.querySeriesInfo(reqDto);
    }

    @Override
    public ResponseDto<GalaxyQueryUserSeriesNftListRespDto> queryUserSeriesNftList(GalaxyQueryUserSeriesNftListReqDto reqDto) {
        return xuperTradeQueryBiz.queryUserSeriesNftList(reqDto);
    }

    @Override
    public ResponseDto<GalaxyQueryUserTradeAllListRespDto> queryUserTradeAllList(GalaxyQueryUserTradeAllListReqDto reqDto) {
        return xuperTradeQueryBiz.queryUserTradeAllList(reqDto);
    }

    @Override
    public ResponseDto<GalaxyQueryUserTradeInListRespDto> queryUserTradeInList(GalaxyQueryUserTradeInListReqDto reqDto) {
        return xuperTradeQueryBiz.queryUserTradeInList(reqDto);
    }

    @Override
    public ResponseDto<GalaxyQueryUserTradeOutListRespDto> queryUserTradeOutList(GalaxyQueryUserTradeOutListReqDto reqDto) {
        return xuperTradeQueryBiz.queryUserTradeOutList(reqDto);
    }
}
