package com.liquidnet.service.goblin.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "GoblinStoreSearchDto", description = "店铺搜素")
@Data
public class GoblinStoreSearchDto implements Serializable, Cloneable {
    private static final long serialVersionUID = 8425727558228094904L;
    @ApiModelProperty(position = 11, value = "店铺id")
    private String storeId;
    @ApiModelProperty(position = 11, value = "店铺名称")
    private String storeName;
    @ApiModelProperty(position = 11, value = "店铺状态[0-填写资料中|1-店铺审核中|2-审核不通过|3-审核通过|4-停业|5-营业]")
    private String status;

    private static final GoblinStoreSearchDto obj = new GoblinStoreSearchDto();
    public static GoblinStoreSearchDto getNew() {
        try {
            return (GoblinStoreSearchDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinStoreSearchDto();
        }
    }
}
