package com.liquidnet.service.goblin.service;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.manage.vo.HelpValueVo;


/**
 * <p>
 * 预约表 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2022-04-07
 */
public interface IGoblinGoodsAnticipateService {

    /**
     * 用户预约 （只能预约不能取消）
     * @param skuId skuId
     * @return Boolean
     */
    ResponseDto<Boolean> userAbout(String skuId);

    /**
     * 根据skuId查询是否预约
     * @param skuId skuId
     * @return Boolean
     */
    ResponseDto<Boolean> selectAnticipate(String skuId);

    /**
     * 用户分享,根据sku发起助力
     * @param skuId skuId
     * @return 分享id
     */
    ResponseDto<String> share(String skuId);

    /**
     * 用户为他人助力
     * @param sid 分享id
     * @return Boolean
     */
    ResponseDto<String> help(String sid);

    /**
     * 获取当前助力信息
     * @param sid 分享id
     * @return 创建关联sku和spu表
     */
    ResponseDto<HelpValueVo> getHelpValue(String sid);

    /**
     * 是否开启助力(返回助力的sid,返回null则没有开启助力)
     * @param skuId skuId
     * @return 返回助力的sid,返回null则没有开启助力
     */
    ResponseDto<String> getTurnOnHelp(String skuId);

    ResponseDto<Boolean> helpSid(String sid);

    /**
     * 组合购用户预约
     * @param mixId 组合购id
     * @return Boolean
     */
    ResponseDto<Boolean> reserveByMix(String mixId);

    /**
     * 根据mixId查询用户是否预约该混合购
     * @param mixId 组合购id
     * @return Boolean
     */
    ResponseDto<Boolean> reserveMixByUid(String mixId);
}
