package com.liquidnet.common.third.zxlnft.dto.nft;

import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 48.NFT 批量转移
 * @class: NftBatchTransferReq
 * @Package com.liquidnet.common.third.zxlnft.dto.nft
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/18 15:56
 */
@Data
public class Nft048BatchTransferReq implements Serializable {
    /**
     * nft可操作者的公钥
     */
    private String pubKey;
    /**
     * nft接收者的地址
     */
    private String receiverAddr;
    /**
     * 要转移的nftId列表，需按照字母序排列，最大30个
     */
    private String nftIds;
    /**
     * 请求ID，每个请求需要填唯一的ID，重复请求用相同的id
     */
    private String operateId;
    /**
     * 操作者的私钥签名，签名对象是(pubKey_receiverAddr_接口名_nftIds_operateId)
     * nftIds按字母序+下划线分割，如xxx_1,xxx_2拼接后为xxx_1_xxx_2
     * 接口名：transferBatch
     */
    private String signature;
    private static final Nft048BatchTransferReq obj = new Nft048BatchTransferReq();
    private static final long serialVersionUID = -7060638899607028431L;

    public static Nft048BatchTransferReq getNew() {
        try {
            return (Nft048BatchTransferReq) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Nft048BatchTransferReq();
        }
    }
}
