-- 创建手环产品表
CREATE TABLE IF NOT EXISTS goblin_recharge_wristband
(
    mid          BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    wristband_id VARCHAR(64)    NOT NULL DEFAULT '' COMMENT '手环ID',
    name         VARCHAR(255)   NOT NULL DEFAULT '' COMMENT '手环名称',
    price        DECIMAL(10, 2) NOT NULL DEFAULT 0 COMMENT '手环价格',
    created_at   timestamp      NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    updated_at   timestamp      NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间'
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='手环信息表';

-- 创建充值金额表
CREATE TABLE IF NOT EXISTS goblin_recharge_amount
(
    mid        BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    amount_id  VARCHAR(64)    NOT NULL DEFAULT '' COMMENT '金额ID',
    name       VARCHAR(255)   NOT NULL DEFAULT '' COMMENT '金额名称',
    price      DECIMAL(10, 2) NOT NULL DEFAULT 0 COMMENT '充值金额',
    created_at timestamp      NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    updated_at timestamp      NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间'
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='充值金额选项表';


-- 手环订单表
CREATE TABLE goblin_bracelet_order
(
    `mid`                  int(10) unsigned                                              NOT NULL AUTO_INCREMENT,
    `order_id`             varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'order_id',
    `user_id`              varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '用户id',
    `bind_name`            varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '绑定用户姓名',
    `bind_mobile`          varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '绑定用户手机号',
    `bind_idcard`          varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '绑定用户身份证号码',
    `req_date`             varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '请求日期',
    `goods_desc`           varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '商品描述',
    `wristband_id`         VARCHAR(64)  CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '手环ID',
    `wristband_price`      DECIMAL(10, 2) NOT NULL DEFAULT '0.00' COMMENT '手环金额',
    `amount_id`            VARCHAR(64)  CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '金额ID',
    `amount_price`         DECIMAL(10, 2) NOT NULL DEFAULT '0.00' COMMENT '充值金额',
    `req_seq_id`           varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '请求流水号',
    `hf_seq_id`            varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '全局流水号',
    `trade_type`           varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '交易类型 T_JSAPI: 微信公众号支付 T_MINIAPP: 微信小程序支付 A_JSAPI: 支付宝JS A_NATIVE: 支付宝正扫 U_NATIVE: 银联正扫 U_JSAPI: 银联 JS D_NATIVE: 数字人民币正扫 T_H5：微信直连H5支付 T_APP：微信APP支付 T_NATIVE：微信正扫',
    `out_trans_id`         varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '用户账单上的交易订单号',
    `party_order_id`       varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '用户账单上的商户订单号',
    `end_time`             varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '支付完成时间 格式yyyyMMddHHmmss',
    `acct_date`            varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci  NOT NULL DEFAULT '' COMMENT '入账时间 格式为yyyyMMdd',
    `price`                decimal(8, 2)                                                 NOT NULL DEFAULT '0.00' COMMENT '单价',
    `price_total`          decimal(8, 2)                                                 NOT NULL DEFAULT '0.00' COMMENT '应付价格',
    `price_actual`         decimal(8, 2)                                                 NOT NULL DEFAULT '0.00' COMMENT '实付价格',
    `price_refund`         decimal(8, 2)                                                 NOT NULL DEFAULT '0.00' COMMENT '退款价格',
    `refund_price_charges` decimal(10, 2)                                                NOT NULL DEFAULT '0.00' COMMENT '退款扣除的手续费金额',
    `refund_number`        int(11)                                                       NOT NULL DEFAULT '0' COMMENT '退款数',
    `time_pay`             varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci          DEFAULT '' COMMENT '支付时间',
    `status`               tinyint(4)                                                    NOT NULL DEFAULT '0' COMMENT '订单状态:0待付款，1已付款，2已关闭，3正在退款，4已退款, 5待关闭 6部分退款',
    `pay_status`           tinyint(4)                                                    NOT NULL DEFAULT '0' COMMENT '支付状态:0未支付 1已支付 2支付失败',
    `fout_trade_no`        varchar(255)                                                  NOT NULL DEFAULT '' COMMENT '迈之的分订单号',
    `cardno`               varchar(255)                                                  NOT NULL DEFAULT '' COMMENT '迈之的设备编号',
    `created_at`           timestamp                                                     NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at`           timestamp                                                     NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    `comment`              varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci          DEFAULT '' COMMENT 'comment',
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_0900_ai_ci COMMENT ='手环订单表';
